/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.DocIdBitSet;
import org.apache.lucene.util.OpenBitSet;
import org.hibernate.search.filter.impl.FilterOptimizationHelper;
import org.junit.Assert;
import org.junit.Test;

public class FiltersOptimizationTest {
    @Test
    public void testSkipMerging() {
        ArrayList<Object> dataIn = new ArrayList<Object>(3);
        dataIn.add(this.makeOpenBitSetTestSet(1, 2, 3, 5, 8, 9, 10, 11));
        dataIn.add(this.makeBitSetTestSet(1, 2, 3, 5, 8, 9, 10, 11, 20));
        dataIn.add(this.makeAnonymousTestSet(1, 2, 3, 5, 8, 9, 10, 11));
        dataIn.add(this.makeAnonymousTestSet(1, 2, 3, 5, 8, 9, 10, 11, 12));
        List merge = FilterOptimizationHelper.mergeByBitAnds(dataIn);
        Assert.assertSame(dataIn, (Object)merge);
    }

    @Test
    public void testDoMergingOnOpenBitSet() throws IOException {
        ArrayList<Object> dataIn = new ArrayList<Object>(3);
        dataIn.add(this.makeOpenBitSetTestSet(1, 2, 5, 8, 9, 10, 11));
        dataIn.add(this.makeOpenBitSetTestSet(1, 2, 3, 5, 8, 11));
        DocIdSet unmergedSet = this.makeAnonymousTestSet(1, 2, 3, 5, 8, 9, 10, 11);
        dataIn.add(unmergedSet);
        List merge = FilterOptimizationHelper.mergeByBitAnds(dataIn);
        Assert.assertNotSame(dataIn, (Object)merge);
        Assert.assertEquals((long)2L, (long)merge.size());
        Assert.assertSame((Object)unmergedSet, merge.get(0));
        Assert.assertTrue((boolean)this.isIdSetSequenceSameTo((DocIdSet)merge.get(1), 1, 2, 5, 8, 11));
    }

    @Test
    public void testDoMergingOnJavaBitSet() throws IOException {
        ArrayList<Object> dataIn = new ArrayList<Object>(3);
        dataIn.add(this.makeBitSetTestSet(1, 2, 5, 8, 9, 10, 11));
        dataIn.add(this.makeBitSetTestSet(1, 2, 3, 5, 8, 11));
        DocIdSet unmergedSet = this.makeAnonymousTestSet(1, 2, 3, 5, 8, 9, 10, 11);
        dataIn.add(unmergedSet);
        List merge = FilterOptimizationHelper.mergeByBitAnds(dataIn);
        Assert.assertNotSame(dataIn, (Object)merge);
        Assert.assertEquals((long)2L, (long)merge.size());
        Assert.assertSame((Object)unmergedSet, merge.get(0));
        Assert.assertTrue((boolean)this.isIdSetSequenceSameTo((DocIdSet)merge.get(1), 1, 2, 5, 8, 11));
    }

    @Test
    public void testSelfIdSequenceTester() throws IOException {
        Assert.assertTrue((boolean)this.isIdSetSequenceSameTo((DocIdSet)this.makeOpenBitSetTestSet(1, 2, 3, 5, 8, 11), 1, 2, 3, 5, 8, 11));
        Assert.assertFalse((boolean)this.isIdSetSequenceSameTo((DocIdSet)this.makeOpenBitSetTestSet(1, 2, 3, 5, 8), 1, 2, 3, 5, 8, 11));
        Assert.assertFalse((boolean)this.isIdSetSequenceSameTo((DocIdSet)this.makeOpenBitSetTestSet(1, 2, 3, 5, 8, 11), 1, 2, 3, 5, 8));
    }

    private boolean isIdSetSequenceSameTo(DocIdSet docIdSet, int ... expectedIds) throws IOException {
        DocIdSetIterator idSetIterator = docIdSet.iterator();
        int[] nArray = expectedIds;
        int n = expectedIds.length;
        int n2 = 0;
        while (n2 < n) {
            int setBit = nArray[n2];
            int currentId = idSetIterator.nextDoc();
            if (currentId == Integer.MAX_VALUE) {
                return false;
            }
            if (currentId != setBit) {
                return false;
            }
            ++n2;
        }
        return idSetIterator.nextDoc() == Integer.MAX_VALUE;
    }

    private DocIdSet makeAnonymousTestSet(int ... docIds) {
        OpenBitSet idSet = this.makeOpenBitSetTestSet(docIds);
        return new DocIdSetHiddenType((DocIdSet)idSet);
    }

    private OpenBitSet makeOpenBitSetTestSet(int ... enabledBits) {
        OpenBitSet set = new OpenBitSet();
        int[] nArray = enabledBits;
        int n = enabledBits.length;
        int n2 = 0;
        while (n2 < n) {
            int position = nArray[n2];
            Assert.assertFalse((boolean)set.get(position));
            set.set((long)position);
            ++n2;
        }
        return set;
    }

    private DocIdBitSet makeBitSetTestSet(int ... enabledBits) {
        BitSet set = new BitSet();
        int[] nArray = enabledBits;
        int n = enabledBits.length;
        int n2 = 0;
        while (n2 < n) {
            int position = nArray[n2];
            Assert.assertFalse((boolean)set.get(position));
            set.set(position);
            ++n2;
        }
        return new DocIdBitSet(set);
    }

    private static class DocIdSetHiddenType
    extends DocIdSet {
        private final DocIdSet bitSet;

        DocIdSetHiddenType(DocIdSet wrapped) {
            this.bitSet = wrapped;
        }

        public DocIdSetIterator iterator() throws IOException {
            return this.bitSet.iterator();
        }
    }
}

