/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.common;

import java.io.InputStream;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.test.SearchTestCase;

public abstract class MultipleSessionsSearchTestCase
extends SearchTestCase {
    protected static final String masterCopy = "/master/copy";
    protected static final String masterMain = "/master/main";
    protected static final String slave = "/slave";
    protected static SessionFactory slaveSessionFactory;
    private Configuration commonCfg;

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.sourceBase", String.valueOf(this.getBaseIndexDir().getAbsolutePath()) + masterCopy);
        cfg.setProperty("hibernate.search.default.indexBase", String.valueOf(this.getBaseIndexDir().getAbsolutePath()) + masterMain);
        cfg.setProperty("hibernate.search.default.refresh", "1");
        cfg.setProperty("hibernate.search.default.directory_provider", "filesystem-master");
    }

    protected void commonConfigure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.sourceBase", String.valueOf(this.getBaseIndexDir().getAbsolutePath()) + masterCopy);
        cfg.setProperty("hibernate.search.default.indexBase", String.valueOf(this.getBaseIndexDir().getAbsolutePath()) + slave);
        cfg.setProperty("hibernate.search.default.refresh", "1");
        cfg.setProperty("hibernate.search.default.directory_provider", "filesystem-slave");
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.buildSlaveSessionFactory();
    }

    @Override
    public void tearDown() throws Exception {
        if (slaveSessionFactory != null) {
            slaveSessionFactory.close();
            slaveSessionFactory = null;
        }
        super.tearDown();
    }

    private void buildSlaveSessionFactory() throws Exception {
        if (slaveSessionFactory != null) {
            throw new IllegalStateException("slaveSessionFactory already created");
        }
        this.setCommonCfg(new Configuration());
        this.commonConfigure(this.commonCfg);
        if (this.recreateSchema()) {
            this.commonCfg.setProperty("hibernate.hbm2ddl.auto", "create-drop");
        }
        Object[] objectArray = this.getCommonAnnotatedPackages();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String aPackage = objectArray[n2];
            this.getCommonConfiguration().addPackage(aPackage);
            ++n2;
        }
        objectArray = this.getCommonAnnotatedClasses();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object aClass = objectArray[n2];
            this.getCommonConfiguration().addAnnotatedClass((Class)aClass);
            ++n2;
        }
        objectArray = this.getCommonXmlFiles();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object xmlFile = objectArray[n2];
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream((String)xmlFile);
            this.getCommonConfiguration().addInputStream(is);
            ++n2;
        }
        slaveSessionFactory = this.getCommonConfiguration().buildSessionFactory();
    }

    private void setCommonCfg(Configuration configuration) {
        this.commonCfg = configuration;
    }

    protected Configuration getCommonConfiguration() {
        return this.commonCfg;
    }

    protected Session getSlaveSession() {
        return slaveSessionFactory.openSession();
    }

    protected static SessionFactory getSlaveSessionFactory() {
        return slaveSessionFactory;
    }

    private String[] getCommonAnnotatedPackages() {
        return new String[0];
    }

    private String[] getCommonXmlFiles() {
        return new String[0];
    }

    @Override
    protected abstract Class<?>[] getAnnotatedClasses();

    protected abstract Class<?>[] getCommonAnnotatedClasses();
}

