/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jpa;

import javax.persistence.EntityManager;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.jpa.Bretzel;
import org.hibernate.search.test.jpa.JPATestCase;

public class EntityManagerTest
extends JPATestCase {
    public void testQuery() throws Exception {
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        em.getTransaction().begin();
        Bretzel bretzel = new Bretzel(23.0f, 34.0f);
        em.persist((Object)bretzel);
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        QueryParser parser = new QueryParser(EntityManagerTest.getTargetLuceneVersion(), "title", TestConstants.stopAnalyzer);
        Query query = parser.parse("saltQty:noword");
        EntityManagerTest.assertEquals((int)0, (int)em.createFullTextQuery(query, new Class[0]).getResultList().size());
        query = new TermQuery(new Term("saltQty", "23.0"));
        EntityManagerTest.assertEquals((String)"getResultList", (int)1, (int)em.createFullTextQuery(query, new Class[0]).getResultList().size());
        EntityManagerTest.assertEquals((String)"getSingleResult and object retrieval", (Object)Float.valueOf(23.0f), (Object)Float.valueOf(((Bretzel)em.createFullTextQuery(query, new Class[0]).getSingleResult()).getSaltQty()));
        EntityManagerTest.assertEquals((int)1, (int)em.createFullTextQuery(query, new Class[0]).getResultSize());
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        em.remove(em.find(Bretzel.class, (Object)bretzel.getId()));
        em.getTransaction().commit();
        em.close();
    }

    public void testIndex() {
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        em.getTransaction().begin();
        Bretzel bretzel = new Bretzel(23.0f, 34.0f);
        em.persist((Object)bretzel);
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        em.index((Object)((Bretzel)em.find(Bretzel.class, (Object)bretzel.getId())));
        em.getTransaction().commit();
        em.getTransaction().begin();
        em.remove(em.find(Bretzel.class, (Object)bretzel.getId()));
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public Class[] getAnnotatedClasses() {
        return new Class[]{Bretzel.class};
    }
}

