/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.perf;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import junit.textui.TestRunner;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.perf.Boat;
import org.hibernate.search.test.perf.SearcherThread;

public class IndexTestDontRun
extends SearchTestCase {
    private static final int TOTAL_SEARCHES = 800;
    private static final int SEARCH_THREADS = 100;

    public static void main(String[] args) {
        TestRunner.run(IndexTestDontRun.class);
    }

    public void notestInit() throws Exception {
        long time = System.nanoTime();
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        int i = 0;
        while (i < 50000) {
            s.save((Object)new Boat("Maria el Seb", "a long" + i + " description of the land" + i));
            ++i;
        }
        tx.commit();
        s.close();
        System.out.println(" init time = " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
    }

    public void testPerformance() throws Exception {
        this.measure(true);
        this.measure(false);
        long measureLucene = this.measure(true);
        long measureSearch = this.measure(false);
        System.out.println("Totaltime Lucene = " + measureLucene);
        System.out.println("Totaltime Search = " + measureSearch);
    }

    public long measure(boolean plainLucene) throws Exception {
        ThreadPoolExecutor threadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(100);
        threadPool.prestartAllCoreThreads();
        CountDownLatch startSignal = new CountDownLatch(1);
        ArrayList<SearcherThread> threadsList = new ArrayList<SearcherThread>(800);
        IndexSearcher indexSearcher = this.getNewSearcher();
        int i = 0;
        while (i < 800) {
            SearcherThread searcherThread = new SearcherThread(i, "name:maria OR description:long" + i, this.getSessions(), indexSearcher, plainLucene, startSignal);
            threadsList.add(searcherThread);
            threadPool.execute(searcherThread);
            ++i;
        }
        threadPool.shutdown();
        startSignal.countDown();
        boolean terminationOk = threadPool.awaitTermination(60L, TimeUnit.SECONDS);
        if (!terminationOk) {
            System.out.println("No enough time to complete the tests!");
            return 0L;
        }
        long totalTime = 0L;
        for (SearcherThread t : threadsList) {
            totalTime += t.getTime();
        }
        return totalTime;
    }

    private IndexSearcher getNewSearcher() {
        Session session = this.getSessions().openSession();
        IndexReader indexReader = Search.getFullTextSession((Session)session).getSearchFactory().getIndexReaderAccessor().open(new Class[]{Boat.class});
        IndexSearcher indexsearcher = new IndexSearcher(indexReader);
        return indexsearcher;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Boat.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.directory_provider", "filesystem");
    }
}

