/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.perf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.perf.Boat;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class SearcherThread
implements Runnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    private final int threadId;
    private final String queryString;
    private final SessionFactory sf;
    private final IndexSearcher indexsearcher;
    private final boolean isLucene;
    private final CountDownLatch startSignal;
    private long time;

    public SearcherThread(int threadId, String queryString, SessionFactory sf, IndexSearcher indexSearcher, boolean isLucene, CountDownLatch startSignal) {
        this.isLucene = isLucene;
        this.threadId = threadId;
        this.queryString = queryString;
        this.sf = sf;
        this.indexsearcher = indexSearcher;
        this.startSignal = startSignal;
    }

    @Override
    public void run() {
        try {
            this.startSignal.await();
        }
        catch (InterruptedException e) {
            log.error((Object)"tests canceled", (Throwable)e);
            Thread.currentThread().interrupt();
            return;
        }
        if (this.isLucene) {
            this.runLucene();
        } else {
            this.runHSearch();
        }
    }

    public void runLucene() {
        try {
            Query q = this.getQuery();
            long start = System.nanoTime();
            TopDocs hits = this.indexsearcher.search(q, 1000);
            ArrayList<String> names = new ArrayList<String>(100);
            int i = 0;
            while (i < 100) {
                Document doc = this.getDocument(this.indexsearcher, hits.scoreDocs[i].doc);
                names.add(doc.get("name"));
                ++i;
            }
            int resultSize = hits.totalHits;
            long totalTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            this.setTime(totalTime);
        }
        catch (ParseException e) {
            System.out.println("[ Thread-id : " + this.threadId + " ] Parse Exception for queryString : " + this.queryString);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("[ Thread-id : " + this.threadId + " ] IO Exception for queryString : " + this.queryString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Document getDocument(IndexSearcher searcher, int docId) {
        try {
            return searcher.doc(docId);
        }
        catch (IOException ioe) {
            throw new SearchException("Unable to retrieve document", (Throwable)ioe);
        }
    }

    private Query getQuery() throws ParseException {
        QueryParser qp = new QueryParser(TestConstants.getTargetLuceneVersion(), "t", TestConstants.standardAnalyzer);
        qp.setLowercaseExpandedTerms(true);
        Query q = qp.parse(this.queryString);
        if (q instanceof BooleanQuery) {
            BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
        }
        return q;
    }

    public void runHSearch() {
        try {
            Query q = this.getQuery();
            FullTextSession ftSession = Search.getFullTextSession((Session)this.sf.openSession());
            FullTextQuery textQuery = ftSession.createFullTextQuery(q, new Class[]{Boat.class}).setMaxResults(100).setProjection(new String[]{"name"});
            long start = System.nanoTime();
            List results = textQuery.list();
            int resultSize = textQuery.getResultSize();
            long totalTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            ftSession.close();
            this.setTime(totalTime);
        }
        catch (ParseException e) {
            log.error((Object)("[ Thread-id : " + this.threadId + " ] Parse Exception for queryString : " + this.queryString));
            e.printStackTrace();
        }
        catch (Throwable e) {
            log.error((Object)("[ Thread-id : " + this.threadId + " ] Exception for queryString : " + this.queryString));
            e.printStackTrace();
        }
    }

    public synchronized long getTime() {
        return this.time;
    }

    public synchronized void setTime(long time) {
        this.time = time;
    }
}

