/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.hibernate.ScrollableResults;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.test.query.AlternateBook;
import org.hibernate.search.test.query.Employee;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScrollableResultsTest {
    private FullTextSessionBuilder builder;
    private FullTextSession sess;

    @Before
    public void setUp() {
        this.builder = new FullTextSessionBuilder();
        this.builder.addAnnotatedClass(AlternateBook.class).addAnnotatedClass(Employee.class).setProperty("hibernate.default_batch_fetch_size", "10").build();
        this.sess = this.builder.openFullTextSession();
        Transaction tx = this.sess.beginTransaction();
        int i = 0;
        while (i < 324) {
            this.sess.persist((Object)new AlternateBook(i, "book about the number " + i));
            ++i;
        }
        i = 0;
        while (i < 133) {
            this.sess.persist((Object)new Employee(i, "Rossi", "dept. num. " + i));
            ++i;
        }
        tx.commit();
    }

    @After
    public void tearDown() {
        this.builder.close();
    }

    @Test
    public void testScrollingForward() {
        Transaction tx = this.sess.beginTransaction();
        TermQuery tq = new TermQuery(new Term("summary", "number"));
        Sort sort = new Sort(new SortField("id", 3));
        ScrollableResults scrollableResults = this.sess.createFullTextQuery((Query)tq, new Class[]{AlternateBook.class}).setSort(sort).setFetchSize(10).setFirstResult(20).setMaxResults(111).scroll();
        Assert.assertEquals((long)-1L, (long)scrollableResults.getRowNumber());
        Assert.assertTrue((boolean)scrollableResults.last());
        Assert.assertEquals((long)110L, (long)scrollableResults.getRowNumber());
        scrollableResults.beforeFirst();
        int position = scrollableResults.getRowNumber();
        while (scrollableResults.next()) {
            int bookId = ++position + 20;
            Assert.assertEquals((long)position, (long)scrollableResults.getRowNumber());
            AlternateBook book = (AlternateBook)scrollableResults.get()[0];
            Assert.assertEquals((long)bookId, (long)book.getId().intValue());
            Assert.assertEquals((Object)("book about the number " + bookId), (Object)book.getSummary());
            Assert.assertTrue((boolean)this.sess.contains((Object)book));
        }
        Assert.assertEquals((long)110L, (long)position);
        scrollableResults.close();
        tx.commit();
    }

    @Test
    public void testScrollingBackwards() {
        Transaction tx = this.sess.beginTransaction();
        TermQuery tq = new TermQuery(new Term("summary", "number"));
        Sort sort = new Sort(new SortField("id", 3));
        ScrollableResults scrollableResults = this.sess.createFullTextQuery((Query)tq, new Class[]{AlternateBook.class}).setSort(sort).setFetchSize(10).scroll();
        scrollableResults.beforeFirst();
        Assert.assertEquals((long)-1L, (long)scrollableResults.getRowNumber());
        Assert.assertTrue((boolean)scrollableResults.last());
        int position = scrollableResults.getRowNumber();
        Assert.assertEquals((long)323L, (long)position);
        while (scrollableResults.previous()) {
            AlternateBook book = (AlternateBook)scrollableResults.get()[0];
            Assert.assertEquals((long)(--position), (long)book.getId().intValue());
            Assert.assertEquals((Object)("book about the number " + position), (Object)book.getSummary());
        }
        Assert.assertEquals((long)0L, (long)position);
        Assert.assertEquals((long)-1L, (long)scrollableResults.getRowNumber());
        scrollableResults.close();
        tx.commit();
    }

    @Test
    public void testResultsAreManaged() {
        AlternateBook book;
        Transaction tx = this.sess.beginTransaction();
        TermQuery tq = new TermQuery(new Term("summary", "number"));
        Sort sort = new Sort(new SortField("id", 3));
        ScrollableResults scrollableResults = this.sess.createFullTextQuery((Query)tq, new Class[]{AlternateBook.class}).setSort(sort).setFetchSize(10).scroll();
        int position = -1;
        while (scrollableResults.next()) {
            book = (AlternateBook)scrollableResults.get()[0];
            Assert.assertTrue((boolean)this.sess.contains((Object)book));
            if (++position % 3 != 0) continue;
            this.sess.evict((Object)book);
            Assert.assertFalse((boolean)this.sess.contains((Object)book));
        }
        Assert.assertEquals((long)323L, (long)position);
        while (scrollableResults.previous()) {
            --position;
            book = (AlternateBook)scrollableResults.get()[0];
            Assert.assertTrue((boolean)this.sess.contains((Object)book));
        }
        Assert.assertEquals((long)-1L, (long)position);
        this.sess.clear();
        while (scrollableResults.next()) {
            ++position;
            book = (AlternateBook)scrollableResults.get()[0];
            Assert.assertTrue((boolean)this.sess.contains((Object)book));
        }
        Assert.assertEquals((long)323L, (long)position);
        tx.commit();
    }

    @Test
    public void testScrollProjectionAndManaged() {
        Object[] objs;
        Transaction tx = this.sess.beginTransaction();
        TermQuery tq = new TermQuery(new Term("dept", "num"));
        Sort sort = new Sort(new SortField("id", 3));
        ScrollableResults scrollableResults = this.sess.createFullTextQuery((Query)tq, new Class[]{Employee.class}).setProjection(new String[]{"_hibernate_class", "__HSearch_id", "__HSearch_This", "lastname", "__HSearch_This"}).setFetchSize(10).setSort(sort).scroll();
        scrollableResults.last();
        Assert.assertEquals((long)132L, (long)scrollableResults.getRowNumber());
        scrollableResults.beforeFirst();
        Assert.assertEquals((long)-1L, (long)scrollableResults.getRowNumber());
        int position = scrollableResults.getRowNumber();
        while (scrollableResults.next()) {
            objs = scrollableResults.get();
            Assert.assertEquals(Employee.class, (Object)objs[0]);
            Assert.assertEquals((Object)(++position), (Object)objs[1]);
            Assert.assertTrue((boolean)(objs[2] instanceof Employee));
            this.sess.contains(objs[2]);
            Assert.assertEquals((Object)"Rossi", (Object)objs[3]);
            Assert.assertTrue((boolean)(objs[4] instanceof Employee));
            this.sess.contains(objs[4]);
            Assert.assertTrue((objs[2] == objs[4] ? 1 : 0) != 0);
            if (position % 3 != 0) continue;
            this.sess.evict(objs[2]);
        }
        Assert.assertEquals((long)132L, (long)position);
        while (scrollableResults.previous()) {
            --position;
            objs = scrollableResults.get();
            Assert.assertTrue((boolean)(objs[2] instanceof Employee));
            this.sess.contains(objs[2]);
            Assert.assertTrue((boolean)(objs[4] instanceof Employee));
            this.sess.contains(objs[4]);
            Assert.assertTrue((objs[2] == objs[4] ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)-1L, (long)position);
        scrollableResults.close();
        tx.commit();
    }
}

