/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.dsl.embedded;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.query.dsl.embedded.ContainerEntity;
import org.hibernate.search.test.query.dsl.embedded.EmbeddedEntity;

public class DslEmbeddedSearchTest
extends SearchTestCase {
    private Session s = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        EmbeddedEntity ee = new EmbeddedEntity();
        ee.setEmbeddedField("embedded");
        ee.setNumber(7);
        ContainerEntity pe = new ContainerEntity();
        pe.setEmbeddedEntity(ee);
        pe.setParentStringValue("theparentvalue");
        this.s = this.openSession();
        this.s.getTransaction().begin();
        this.s.persist((Object)pe);
        this.s.getTransaction().commit();
    }

    @Override
    public void tearDown() throws Exception {
        this.s.clear();
        this.deleteAll(this.s, ContainerEntity.class);
        this.s.close();
        super.tearDown();
    }

    public void testSearchString() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.s);
        QueryBuilder qb = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(ContainerEntity.class).get();
        Query q = qb.keyword().onField("emb.embeddedField").matching((Object)"embedded").createQuery();
        List<ContainerEntity> results = this.execute(fullTextSession, q);
        DslEmbeddedSearchTest.assertEquals((String)"DSL didn't find the embedded string field", (int)1, (int)results.size());
        DslEmbeddedSearchTest.assertEquals((String)"embedded", (String)results.get(0).getEmbeddedEntity().getEmbeddedField());
    }

    public void testSearchNumberWithFieldBridge() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.s);
        QueryBuilder qb = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(ContainerEntity.class).get();
        Query q = qb.keyword().onField("emb.num").matching((Object)7).createQuery();
        List<ContainerEntity> results = this.execute(fullTextSession, q);
        DslEmbeddedSearchTest.assertEquals((String)"DSL didn't find the embedded numeric field", (int)1, (int)results.size());
        DslEmbeddedSearchTest.assertEquals((Object)7, (Object)results.get(0).getEmbeddedEntity().getNumber());
    }

    private List<ContainerEntity> execute(FullTextSession fullTextSession, Query q) {
        FullTextQuery combinedQuery = fullTextSession.createFullTextQuery(q, new Class[]{ContainerEntity.class});
        return combinedQuery.list();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{ContainerEntity.class};
    }

    private void deleteAll(Session s, Class<?> ... classes) {
        Transaction tx = s.beginTransaction();
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> each = classArray[n2];
            List list = s.createCriteria(each).list();
            for (Object object : list) {
                s.delete(object);
            }
            ++n2;
        }
        tx.commit();
    }
}

