/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.test.query.facet.AbstractFacetTest;
import org.hibernate.search.test.query.facet.Car;
import org.hibernate.search.test.query.facet.Fruit;

public class FacetFilteringTest
extends AbstractFacetTest {
    public void testDiscreteFacetDrillDown() throws Exception {
        String indexFieldName = "cubicCapacity";
        String facetName = "ccs";
        Query luceneQuery = this.queryBuilder(Car.class).keyword().onField("make").matching((Object)"Honda").createQuery();
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().createFacetingRequest();
        FullTextQuery query = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Car.class});
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(request);
        query.setFirstResult(0).setMaxResults(1);
        FacetFilteringTest.assertEquals((String)"Wrong number of query matches", (int)13, (int)query.getResultSize());
        List facetList = facetManager.getFacets("ccs");
        int[] nArray = new int[4];
        nArray[0] = 5;
        nArray[1] = 4;
        nArray[2] = 4;
        this.assertFacetCounts(facetList, nArray);
        facetManager.getFacetGroup("ccs").selectFacets(new Facet[]{(Facet)facetList.get(0)});
        query.list();
        FacetFilteringTest.assertEquals((String)"Wrong number of query matches", (int)5, (int)query.getResultSize());
        List newFacetList = facetManager.getFacets("ccs");
        int[] nArray2 = new int[4];
        nArray2[0] = 5;
        this.assertFacetCounts(newFacetList, nArray2);
        facetManager.getFacetGroup("ccs").selectFacets(new Facet[]{(Facet)facetList.get(1)});
        query.setMaxResults(Integer.MAX_VALUE);
        FacetFilteringTest.assertEquals((String)"Wrong number of query matches", (int)9, (int)query.list().size());
        newFacetList = facetManager.getFacets("ccs");
        int[] nArray3 = new int[4];
        nArray3[0] = 5;
        nArray3[1] = 4;
        this.assertFacetCounts(newFacetList, nArray3);
    }

    public void testMultipleFacetDrillDown() throws Exception {
        String ccsFacetName = "ccs";
        String ccsFacetFieldName = "cubicCapacity";
        FacetingRequest ccsFacetRequest = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().createFacetingRequest();
        String colorFacetName = "color";
        String colorFacetFieldName = "color";
        FacetingRequest colorFacetRequest = this.queryBuilder(Car.class).facet().name("color").onField("color").discrete().createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Car.class);
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(colorFacetRequest);
        facetManager.enableFaceting(ccsFacetRequest);
        FacetFilteringTest.assertEquals((String)"Wrong number of query matches", (int)50, (int)query.getResultSize());
        this.assertFacetCounts(facetManager.getFacets("color"), new int[]{12, 12, 12, 12, 2});
        this.assertFacetCounts(facetManager.getFacets("ccs"), new int[]{17, 16, 16, 1});
        Facet colorFacet = (Facet)facetManager.getFacets("color").get(0);
        facetManager.getFacetGroup("color").selectFacets(new Facet[]{colorFacet});
        int[] nArray = new int[5];
        nArray[0] = 12;
        this.assertFacetCounts(facetManager.getFacets("color"), nArray);
        int[] nArray2 = new int[4];
        nArray2[0] = 4;
        nArray2[1] = 4;
        nArray2[2] = 4;
        this.assertFacetCounts(facetManager.getFacets("ccs"), nArray2);
        Facet ccsFacet = (Facet)facetManager.getFacets("ccs").get(0);
        facetManager.getFacetGroup("color").selectFacets(new Facet[]{colorFacet});
        facetManager.getFacetGroup("ccs").selectFacets(new Facet[]{ccsFacet});
        int[] nArray3 = new int[5];
        nArray3[0] = 4;
        this.assertFacetCounts(facetManager.getFacets("color"), nArray3);
        int[] nArray4 = new int[4];
        nArray4[0] = 4;
        this.assertFacetCounts(facetManager.getFacets("ccs"), nArray4);
        facetManager.getFacetGroup("color").clearSelectedFacets();
        facetManager.getFacetGroup("ccs").clearSelectedFacets();
        this.assertFacetCounts(facetManager.getFacets("color"), new int[]{12, 12, 12, 12, 2});
        this.assertFacetCounts(facetManager.getFacets("ccs"), new int[]{17, 16, 16, 1});
    }

    public void testRangeFacetDrillDown() {
        String indexFieldName = "price";
        String priceRange = "priceRange";
        FacetingRequest rangeRequest = this.queryBuilder(Fruit.class).facet().name("priceRange").onField("price").range().from((Object)0.0).to((Object)1.0).from((Object)1.01).to((Object)1.5).from((Object)1.51).to((Object)3.0).from((Object)4.0).to((Object)5.0).createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Fruit.class);
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(rangeRequest);
        FacetFilteringTest.assertEquals((String)"Wrong number of query matches", (int)10, (int)query.getResultSize());
        List facets = facetManager.getFacets("priceRange");
        int[] nArray = new int[4];
        nArray[0] = 5;
        nArray[1] = 3;
        nArray[2] = 2;
        this.assertFacetCounts(facets, nArray);
        facetManager.getFacetGroup("priceRange").selectFacets(new Facet[]{(Facet)facets.get(2)});
        FacetFilteringTest.assertEquals((String)"Wrong number of query matches", (int)2, (int)query.list().size());
        List newFacetList = facetManager.getFacets("priceRange");
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        this.assertFacetCounts(newFacetList, nArray2);
    }

    @Override
    public void loadTestData(Session session) {
        Transaction tx = session.beginTransaction();
        int i = 0;
        while (i < fruits.length) {
            Fruit fruit = new Fruit(fruits[i], fruitPrices[i]);
            session.save((Object)fruit);
            ++i;
        }
        String[] stringArray = makes;
        int n = makes.length;
        int n2 = 0;
        while (n2 < n) {
            String make = stringArray[n2];
            String[] stringArray2 = colors;
            int n3 = colors.length;
            int n4 = 0;
            while (n4 < n3) {
                String color = stringArray2[n4];
                int[] nArray = ccs;
                int n5 = ccs.length;
                int n6 = 0;
                while (n6 < n5) {
                    int cc = nArray[n6];
                    Car car = new Car(make, color, cc);
                    session.save((Object)car);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        Car car = new Car("Honda", "yellow", 2407);
        session.save((Object)car);
        car = new Car("Ford", "yellow", 2500);
        session.save((Object)car);
        tx.commit();
        session.clear();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Car.class, Fruit.class};
    }
}

