/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.SearchException;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.test.query.facet.AbstractFacetTest;
import org.hibernate.search.test.query.facet.Car;

public class SimpleFacetingTest
extends AbstractFacetTest {
    private final String indexFieldName = "cubicCapacity";
    private final String facetName = "ccs";

    public void testSimpleFaceting() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        SimpleFacetingTest.assertEquals((String)"Wrong number of facets", (int)4, (int)facetList.size());
    }

    public void testDefaultSortOrderIsCount() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        int[] nArray = new int[4];
        nArray[0] = 5;
        nArray[1] = 4;
        nArray[2] = 4;
        this.assertFacetCounts(facetList, nArray);
    }

    public void testCountSortOrderAsc() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().orderedBy(FacetSortOrder.COUNT_ASC).createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        int[] nArray = new int[4];
        nArray[1] = 4;
        nArray[2] = 4;
        nArray[3] = 5;
        this.assertFacetCounts(facetList, nArray);
    }

    public void testCountSortOrderDesc() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().orderedBy(FacetSortOrder.COUNT_DESC).createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        int[] nArray = new int[4];
        nArray[0] = 5;
        nArray[1] = 4;
        nArray[2] = 4;
        this.assertFacetCounts(facetList, nArray);
    }

    public void testAlphabeticalSortOrder() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().orderedBy(FacetSortOrder.FIELD_VALUE).createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        int i = 1;
        while (i < facetList.size() - 1) {
            String currentFacetValue;
            String previousFacetValue = ((Facet)facetList.get(i - 1)).getValue();
            SimpleFacetingTest.assertTrue((String)"Wrong alphabetical sort order", (previousFacetValue.compareTo(currentFacetValue = ((Facet)facetList.get(i)).getValue()) < 0 ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testZeroCountsExcluded() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().orderedBy(FacetSortOrder.COUNT_DESC).includeZeroCounts(false).createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        this.assertFacetCounts(facetList, new int[]{5, 4, 4});
    }

    public void testMaxFacetCounts() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().orderedBy(FacetSortOrder.COUNT_DESC).maxFacetCount(1).createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        SimpleFacetingTest.assertEquals((String)"The number of facets should be restricted", (int)1, (int)facetList.size());
        this.assertFacetCounts(facetList, new int[]{5});
    }

    public void testNullFieldNameThrowsException() {
        try {
            this.queryBuilder(Car.class).facet().name("ccs").onField(null).discrete().createFacetingRequest();
            SimpleFacetingTest.fail((String)"null should not be a valid field name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNullRequestNameThrowsException() {
        try {
            this.queryBuilder(Car.class).facet().name(null).onField("cubicCapacity").discrete().createFacetingRequest();
            SimpleFacetingTest.fail((String)"null should not be a valid request name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testUnknownFieldNameReturnsEmptyResults() {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("foo").onField("foobar").discrete().createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        SimpleFacetingTest.assertTrue((boolean)facetList.isEmpty());
    }

    public void testRangeDefinitionSortOrderThrowsExceptionForDiscreteFaceting() {
        try {
            this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().orderedBy(FacetSortOrder.RANGE_DEFINITION_ODER).createFacetingRequest();
            SimpleFacetingTest.fail((String)"RANGE_DEFINITION_ODER not allowed on discrete faceting");
        }
        catch (SearchException searchException) {
            // empty catch block
        }
    }

    public void testEnableDisableFacets() {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        SimpleFacetingTest.assertTrue((String)"We should have facet results", (query.getFacetManager().getFacets("ccs").size() > 0 ? 1 : 0) != 0);
        query.getFacetManager().disableFaceting("ccs");
        query.list();
        SimpleFacetingTest.assertTrue((String)"We should have no facets", (query.getFacetManager().getFacets("ccs").size() == 0 ? 1 : 0) != 0);
    }

    public void testMultipleFacets() {
        String descendingOrderedFacet = "desc";
        FacetingRequest requestDesc = this.queryBuilder(Car.class).facet().name("desc").onField("cubicCapacity").discrete().createFacetingRequest();
        String ascendingOrderedFacet = "asc";
        FacetingRequest requestAsc = this.queryBuilder(Car.class).facet().name("asc").onField("cubicCapacity").discrete().orderedBy(FacetSortOrder.COUNT_ASC).createFacetingRequest();
        TermQuery term = new TermQuery(new Term("make", "honda"));
        FullTextQuery query = this.fullTextSession.createFullTextQuery((Query)term, new Class[]{Car.class});
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(requestDesc);
        facetManager.enableFaceting(requestAsc);
        int[] nArray = new int[4];
        nArray[0] = 5;
        nArray[1] = 4;
        nArray[2] = 4;
        this.assertFacetCounts(facetManager.getFacets("desc"), nArray);
        int[] nArray2 = new int[4];
        nArray2[1] = 4;
        nArray2[2] = 4;
        nArray2[3] = 5;
        this.assertFacetCounts(facetManager.getFacets("asc"), nArray2);
        facetManager.disableFaceting("desc");
        SimpleFacetingTest.assertTrue((String)"descendingOrderedFacet should be disabled", (boolean)query.getFacetManager().getFacets("desc").isEmpty());
        int[] nArray3 = new int[4];
        nArray3[1] = 4;
        nArray3[2] = 4;
        nArray3[3] = 5;
        this.assertFacetCounts(facetManager.getFacets("asc"), nArray3);
        facetManager.disableFaceting("asc");
        SimpleFacetingTest.assertTrue((String)"descendingOrderedFacet should be disabled", (boolean)facetManager.getFacets("desc").isEmpty());
        SimpleFacetingTest.assertTrue((String)"ascendingOrderedFacet should be disabled", (boolean)facetManager.getFacets("asc").isEmpty());
    }

    private FullTextQuery queryHondaWithFacet(FacetingRequest request) {
        Query luceneQuery = this.queryBuilder(Car.class).keyword().onField("make").matching((Object)"Honda").createQuery();
        FullTextQuery query = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Car.class});
        query.getFacetManager().enableFaceting(request);
        SimpleFacetingTest.assertEquals((String)"Wrong number of query matches", (int)13, (int)query.getResultSize());
        return query;
    }

    @Override
    public void loadTestData(Session session) {
        Transaction tx = session.beginTransaction();
        String[] stringArray = makes;
        int n = makes.length;
        int n2 = 0;
        while (n2 < n) {
            String make = stringArray[n2];
            String[] stringArray2 = colors;
            int n3 = colors.length;
            int n4 = 0;
            while (n4 < n3) {
                String color = stringArray2[n4];
                int[] nArray = ccs;
                int n5 = ccs.length;
                int n6 = 0;
                while (n6 < n5) {
                    int cc = nArray[n6];
                    Car car = new Car(make, color, cc);
                    session.save((Object)car);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        Car car = new Car("Honda", "yellow", 2407);
        session.save((Object)car);
        car = new Car("Ford", "yellow", 2500);
        session.save((Object)car);
        tx.commit();
        session.clear();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Car.class};
    }
}

