/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.fieldcache;

import java.math.BigDecimal;
import java.util.List;
import junit.framework.Assert;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.engine.Country;
import org.hibernate.search.test.engine.Location;
import org.hibernate.search.test.engine.PinPoint;
import org.hibernate.search.test.util.FieldSelectorLeakingReaderProvider;

public class CachedNumericIdTest
extends SearchTestCase {
    private static final int NUM_LOCATIONS = 50;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.prepareData();
    }

    public void testLocationLoading() {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        QueryBuilder queryBuilder = this.getSearchFactory().buildQueryBuilder().forEntity(Location.class).get();
        Query query = queryBuilder.all().createQuery();
        FieldSelectorLeakingReaderProvider.resetFieldSelector();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Location.class});
        fullTextQuery.setSort(new Sort(new SortField("description", 3)));
        List locations = fullTextQuery.list();
        FieldSelectorLeakingReaderProvider.assertFieldSelectorDisabled();
        Assert.assertEquals((int)50, (int)locations.size());
        for (Location location : locations) {
            int id = location.getId();
            Assert.assertEquals((String)(String.valueOf(String.valueOf(id)) + "42"), (String)location.getDescription());
        }
        tx.commit();
        session.close();
    }

    private void prepareData() {
        Session session = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        Transaction transaction = fullTextSession.beginTransaction();
        Country italy = new Country("Italy", 39.0);
        int i = 0;
        while (i < 50) {
            session.persist((Object)new Location(i, Long.valueOf(i), 7 * i, Double.valueOf(9 * i), 100 - i, String.valueOf(String.valueOf(i)) + "42", null, italy, BigDecimal.ONE));
            ++i;
        }
        transaction.commit();
        session.close();
    }

    private void cleanData() {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        session.createQuery("delete Location").executeUpdate();
        tx.commit();
        session.close();
    }

    @Override
    public void tearDown() throws Exception {
        this.cleanData();
        super.tearDown();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{PinPoint.class, Location.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.indexwriter.transaction.max_merge_docs", "10");
        cfg.setProperty("hibernate.search.default.reader.strategy", FieldSelectorLeakingReaderProvider.class.getName());
    }
}

