/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.fieldcache;

import java.lang.annotation.ElementType;
import java.util.List;
import junit.framework.Assert;
import org.apache.lucene.search.Query;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.FieldCacheType;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.configuration.Address;
import org.hibernate.search.test.configuration.Country;
import org.hibernate.search.test.configuration.Item;
import org.hibernate.search.test.configuration.ProductCatalog;
import org.hibernate.search.test.util.FieldSelectorLeakingReaderProvider;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.Test;

public class ClasstypeFieldCacheExtractionTest {
    @Test
    public void testWithoutFieldCacheOnMixedIds() {
        Mapping.enableFieldCache = new FieldCacheType[0];
        this.wrapper(true, "id", "addressId", "_hibernate_class");
    }

    @Test
    public void testWithFieldCacheOnTypOnMixedIds() {
        Mapping.enableFieldCache = new FieldCacheType[]{FieldCacheType.CLASS};
        this.wrapper(true, "id", "addressId");
    }

    @Test
    public void testWithFieldCacheOnTypeAndIdOnMixedIds() {
        Mapping.enableFieldCache = new FieldCacheType[]{FieldCacheType.CLASS, FieldCacheType.ID};
        this.wrapper(true, "id", "addressId");
    }

    @Test
    public void testWithoutFieldCache() {
        Mapping.enableFieldCache = new FieldCacheType[0];
        this.wrapper(false, "id");
    }

    @Test
    public void testWithFieldCacheOnType() {
        Mapping.enableFieldCache = new FieldCacheType[]{FieldCacheType.CLASS};
        this.wrapper(false, "id");
    }

    @Test
    public void testWithFieldCacheOnTypeAndId() {
        Mapping.enableFieldCache = new FieldCacheType[]{FieldCacheType.CLASS, FieldCacheType.ID};
        this.wrapper(false, new String[0]);
    }

    public void wrapper(boolean usingMixedIds, String ... expectedLoadedFields) {
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        if (usingMixedIds) {
            builder.addAnnotatedClass(Address.class).addAnnotatedClass(Country.class);
        }
        builder.addAnnotatedClass(Item.class).addAnnotatedClass(ProductCatalog.class).setProperty("hibernate.search.default.reader.strategy", FieldSelectorLeakingReaderProvider.class.getName()).setProperty("hibernate.search.model_mapping", Mapping.class.getName()).build();
        try {
            this.storeDemoData(builder);
            this.performtest(builder, expectedLoadedFields);
        }
        finally {
            builder.close();
        }
    }

    private void performtest(FullTextSessionBuilder builder, String ... expectedLoadedFields) {
        QueryBuilder queryBuilder = builder.getSearchFactory().buildQueryBuilder().forEntity(Item.class).get();
        Query query = queryBuilder.all().createQuery();
        FullTextSession fullTextSession = builder.openFullTextSession();
        Transaction transaction = fullTextSession.beginTransaction();
        FieldSelectorLeakingReaderProvider.resetFieldSelector();
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[0]);
        List list = fullTextQuery.list();
        Assert.assertEquals((int)2, (int)list.size());
        FieldSelectorLeakingReaderProvider.assertFieldSelectorEnabled((String[])expectedLoadedFields);
        transaction.commit();
        fullTextSession.close();
    }

    private void storeDemoData(FullTextSessionBuilder builder) {
        FullTextSession fullTextSession = builder.openFullTextSession();
        Transaction transaction = fullTextSession.beginTransaction();
        Item ssd = new Item();
        ssd.setDescription("intel solid state disk");
        Item wd = new Item();
        wd.setDescription("western digital hibrid disk");
        fullTextSession.persist((Object)ssd);
        fullTextSession.persist((Object)wd);
        transaction.commit();
        fullTextSession.close();
    }

    public static class Mapping {
        static FieldCacheType[] enableFieldCache;

        @Factory
        public SearchMapping build() {
            SearchMapping mapping = new SearchMapping();
            mapping.entity(Address.class).indexed().cacheFromIndex(enableFieldCache).indexName("single-index").entity(Country.class).indexed().cacheFromIndex(enableFieldCache).indexName("single-index").property("name", ElementType.FIELD).entity(Item.class).indexed().cacheFromIndex(enableFieldCache);
            return mapping;
        }
    }
}

