/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.serialization;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttributeImpl;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.Payload;
import org.apache.lucene.util.AttributeImpl;
import org.apache.solr.handler.AnalysisRequestHandlerBase;
import org.fest.assertions.Assertions;
import org.fest.assertions.MapAssert;
import org.fest.assertions.ObjectAssert;
import org.fest.assertions.StringAssert;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.indexes.serialization.avro.impl.AvroSerializationProvider;
import org.hibernate.search.indexes.serialization.impl.CopyTokenStream;
import org.hibernate.search.indexes.serialization.impl.PluggableSerializationLuceneWorkSerializer;
import org.hibernate.search.indexes.serialization.impl.SerializationHelper;
import org.hibernate.search.indexes.serialization.spi.SerializableTokenStream;
import org.hibernate.search.indexes.serialization.spi.SerializationProvider;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.serialization.RemoteEntity;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.Test;

public class SerializationTest
extends SearchTestCase {
    private static final Log log = LoggerFactory.make();

    @Test
    public void testAvroSerialization() throws Exception {
        PluggableSerializationLuceneWorkSerializer converter = new PluggableSerializationLuceneWorkSerializer((SerializationProvider)new AvroSerializationProvider(), this.getSearchFactoryImpl());
        List<LuceneWork> works = this.buildWorks();
        byte[] bytes = converter.toSerializedModel(works);
        List copyOfWorks = converter.toLuceneWorks(bytes);
        Assertions.assertThat((List)copyOfWorks).hasSize(works.size());
        int index = 0;
        while (index < works.size()) {
            this.assertLuceneWork(works.get(index), (LuceneWork)copyOfWorks.get(index));
            ++index;
        }
    }

    @Test
    public void testAvroSerializationPerf() throws Exception {
        int loop = 10;
        PluggableSerializationLuceneWorkSerializer converter = new PluggableSerializationLuceneWorkSerializer((SerializationProvider)new AvroSerializationProvider(), this.getSearchFactoryImpl());
        List<LuceneWork> works = this.buildWorks();
        byte[] javaBytes = null;
        long begin = System.nanoTime();
        int i = 0;
        while (i < 10) {
            javaBytes = SerializationHelper.toByteArray((Serializable)((Serializable)((Object)works)));
            ++i;
        }
        long end = System.nanoTime();
        log.debug((Object)("Java serialization: " + (end - begin) / 1000000L));
        log.debug((Object)("Java message size: " + javaBytes.length));
        begin = System.nanoTime();
        List copyOfWorkForJavaSerial = null;
        int i2 = 0;
        while (i2 < 10) {
            copyOfWorkForJavaSerial = (List)((Object)SerializationHelper.toSerializable((byte[])javaBytes, (ClassLoader)Thread.currentThread().getContextClassLoader()));
            ++i2;
        }
        end = System.nanoTime();
        log.debug((Object)("Java de-serialization: " + (end - begin) / 1000000L));
        byte[] avroBytes = null;
        begin = System.nanoTime();
        int i3 = 0;
        while (i3 < 10) {
            avroBytes = converter.toSerializedModel(works);
            ++i3;
        }
        end = System.nanoTime();
        log.debug((Object)("Avro serialization: " + (end - begin) / 1000000L));
        log.debug((Object)("Avro message size: " + avroBytes.length));
        List copyOfWorks = null;
        begin = System.nanoTime();
        int i4 = 0;
        while (i4 < 10) {
            copyOfWorks = converter.toLuceneWorks(avroBytes);
            ++i4;
        }
        end = System.nanoTime();
        log.debug((Object)("Avro deserialization: " + (end - begin) / 1000000L));
        log.debug((Object)(copyOfWorks == copyOfWorkForJavaSerial ? 1 : 0));
    }

    private List<LuceneWork> buildWorks() throws Exception {
        ArrayList<LuceneWork> works = new ArrayList<LuceneWork>();
        works.add((LuceneWork)OptimizeLuceneWork.INSTANCE);
        works.add((LuceneWork)OptimizeLuceneWork.INSTANCE);
        works.add((LuceneWork)new OptimizeLuceneWork(RemoteEntity.class));
        works.add((LuceneWork)new PurgeAllLuceneWork(RemoteEntity.class));
        works.add((LuceneWork)new PurgeAllLuceneWork(RemoteEntity.class));
        works.add((LuceneWork)new DeleteLuceneWork((Serializable)Long.valueOf(123L), "123", RemoteEntity.class));
        works.add((LuceneWork)new DeleteLuceneWork((Serializable)((Object)"Sissi"), "Sissi", RemoteEntity.class));
        works.add((LuceneWork)new DeleteLuceneWork((Serializable)new URL("http://emmanuelbernard.com"), "http://emmanuelbernard.com", RemoteEntity.class));
        Document doc = new Document();
        doc.setBoost(2.3f);
        NumericField numField = new NumericField("double", 23, Field.Store.NO, true);
        numField.setDoubleValue(23.0);
        numField.setOmitNorms(true);
        numField.setOmitTermFreqAndPositions(true);
        numField.setBoost(3.0f);
        doc.add((Fieldable)numField);
        numField = new NumericField("int", 23, Field.Store.NO, true);
        numField.setIntValue(23);
        doc.add((Fieldable)numField);
        numField = new NumericField("float", 23, Field.Store.NO, true);
        numField.setFloatValue(2.3f);
        doc.add((Fieldable)numField);
        numField = new NumericField("long", 23, Field.Store.NO, true);
        numField.setLongValue(23L);
        doc.add((Fieldable)numField);
        HashMap<String, String> analyzers = new HashMap<String, String>();
        analyzers.put("godo", "ngram");
        works.add((LuceneWork)new AddLuceneWork((Serializable)Integer.valueOf(123), "123", RemoteEntity.class, doc, analyzers));
        doc = new Document();
        doc.setBoost(2.3f);
        Field field = new Field("StringF", "String field", Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_OFFSETS);
        field.setOmitNorms(true);
        field.setOmitTermFreqAndPositions(true);
        field.setBoost(3.0f);
        doc.add((Fieldable)field);
        field = new Field("StringF2", "String field 2", Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_OFFSETS);
        doc.add((Fieldable)field);
        byte[] array = new byte[]{2, 5, 5, 8};
        field = new Field("binary", array, 0, array.length);
        doc.add((Fieldable)field);
        SerializableStringReader reader = new SerializableStringReader();
        field = new Field("ReaderField", (Reader)reader, Field.TermVector.WITH_OFFSETS);
        doc.add((Fieldable)field);
        List<List<AttributeImpl>> tokens = this.buildTokenSteamWithAttributes();
        CopyTokenStream tokenStream = new CopyTokenStream(tokens);
        field = new Field("tokenstream", (TokenStream)tokenStream, Field.TermVector.WITH_POSITIONS_OFFSETS);
        field.setOmitNorms(true);
        field.setOmitTermFreqAndPositions(true);
        field.setBoost(3.0f);
        doc.add((Fieldable)field);
        works.add((LuceneWork)new UpdateLuceneWork((Serializable)Integer.valueOf(1234), "1234", RemoteEntity.class, doc));
        works.add((LuceneWork)new AddLuceneWork((Serializable)Integer.valueOf(125), "125", RemoteEntity.class, new Document()));
        return works;
    }

    private List<List<AttributeImpl>> buildTokenSteamWithAttributes() {
        ArrayList<List<AttributeImpl>> tokens = new ArrayList<List<AttributeImpl>>();
        tokens.add(new ArrayList());
        AnalysisRequestHandlerBase.TokenTrackingAttributeImpl attrImpl = new AnalysisRequestHandlerBase.TokenTrackingAttributeImpl();
        attrImpl.reset(new int[]{1, 2, 3}, 4);
        ((List)tokens.get(0)).add(attrImpl);
        CharTermAttributeImpl charAttr = new CharTermAttributeImpl();
        charAttr.append("Wazzza");
        ((List)tokens.get(0)).add(charAttr);
        PayloadAttributeImpl payloadAttribute = new PayloadAttributeImpl();
        byte[] byArray = new byte[4];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        payloadAttribute.setPayload(new Payload(byArray));
        ((List)tokens.get(0)).add(payloadAttribute);
        KeywordAttributeImpl keywordAttr = new KeywordAttributeImpl();
        keywordAttr.setKeyword(true);
        ((List)tokens.get(0)).add(keywordAttr);
        PositionIncrementAttributeImpl posIncrAttr = new PositionIncrementAttributeImpl();
        posIncrAttr.setPositionIncrement(3);
        ((List)tokens.get(0)).add(posIncrAttr);
        FlagsAttributeImpl flagsAttr = new FlagsAttributeImpl();
        flagsAttr.setFlags(435);
        ((List)tokens.get(0)).add(flagsAttr);
        TypeAttributeImpl typeAttr = new TypeAttributeImpl();
        typeAttr.setType("acronym");
        ((List)tokens.get(0)).add(typeAttr);
        OffsetAttributeImpl offsetAttr = new OffsetAttributeImpl();
        offsetAttr.setOffset(4, 7);
        ((List)tokens.get(0)).add(offsetAttr);
        return tokens;
    }

    private void assertLuceneWork(LuceneWork work, LuceneWork copy) {
        Assertions.assertThat((Object)copy).isInstanceOf(work.getClass());
        if (work instanceof OptimizeLuceneWork) {
            SerializationTest.assertNotNull((Object)copy);
            SerializationTest.assertTrue((boolean)(copy instanceof OptimizeLuceneWork));
        } else if (work instanceof PurgeAllLuceneWork) {
            this.assertPurgeAll((PurgeAllLuceneWork)work, (PurgeAllLuceneWork)copy);
        } else if (work instanceof DeleteLuceneWork) {
            this.assertDelete((DeleteLuceneWork)work, (DeleteLuceneWork)copy);
        } else if (work instanceof AddLuceneWork) {
            this.assertAdd((AddLuceneWork)work, (AddLuceneWork)copy);
        } else if (work instanceof UpdateLuceneWork) {
            this.assertUpdate((UpdateLuceneWork)work, (UpdateLuceneWork)copy);
        } else {
            SerializationTest.fail((String)"unexpected type");
        }
    }

    private void assertAdd(AddLuceneWork work, AddLuceneWork copy) {
        ((ObjectAssert)Assertions.assertThat((Object)work.getEntityClass()).as("Add.getEntityClass is not copied")).isEqualTo((Object)copy.getEntityClass());
        ((ObjectAssert)Assertions.assertThat((Object)work.getId()).as("Add.getId is not copied")).isEqualTo((Object)copy.getId());
        ((StringAssert)Assertions.assertThat((String)work.getIdInString()).as("Add.getIdInString is not the same")).isEqualTo((Object)copy.getIdInString());
        ((MapAssert)Assertions.assertThat((Map)work.getFieldToAnalyzerMap()).as("Add.getFieldToAnalyzerMap is not the same")).isEqualTo((Object)copy.getFieldToAnalyzerMap());
        this.assertDocument(work.getDocument(), copy.getDocument());
    }

    private void assertUpdate(UpdateLuceneWork work, UpdateLuceneWork copy) {
        ((ObjectAssert)Assertions.assertThat((Object)work.getEntityClass()).as("Add.getEntityClass is not copied")).isEqualTo((Object)copy.getEntityClass());
        ((ObjectAssert)Assertions.assertThat((Object)work.getId()).as("Add.getId is not copied")).isEqualTo((Object)copy.getId());
        ((StringAssert)Assertions.assertThat((String)work.getIdInString()).as("Add.getIdInString is not the same")).isEqualTo((Object)copy.getIdInString());
        ((MapAssert)Assertions.assertThat((Map)work.getFieldToAnalyzerMap()).as("Add.getFieldToAnalyzerMap is not the same")).isEqualTo((Object)copy.getFieldToAnalyzerMap());
        this.assertDocument(work.getDocument(), copy.getDocument());
    }

    private void assertDocument(Document document, Document copy) {
        Assertions.assertThat((float)document.getBoost()).isEqualTo(copy.getBoost());
        int index = 0;
        while (index < document.getFields().size()) {
            Fieldable field = (Fieldable)document.getFields().get(index);
            Fieldable fieldCopy = (Fieldable)copy.getFields().get(index);
            Assertions.assertThat((Object)field).isInstanceOf(fieldCopy.getClass());
            if (field instanceof NumericField) {
                this.assertNumericField((NumericField)field, (NumericField)fieldCopy);
            } else if (field instanceof Field) {
                this.assertNormalField((Field)field, (Field)fieldCopy);
            }
            ++index;
        }
    }

    private void assertNormalField(Field field, Field copy) {
        Assertions.assertThat((String)copy.name()).isEqualTo((Object)field.name());
        Assertions.assertThat((int)copy.getBinaryLength()).isEqualTo(field.getBinaryLength());
        Assertions.assertThat((int)copy.getBinaryOffset()).isEqualTo(field.getBinaryOffset());
        Assertions.assertThat((byte[])copy.getBinaryValue()).isEqualTo(field.getBinaryValue());
        Assertions.assertThat((float)copy.getBoost()).isEqualTo(field.getBoost());
        Assertions.assertThat((boolean)copy.getOmitNorms()).isEqualTo(field.getOmitNorms());
        Assertions.assertThat((boolean)copy.getOmitTermFreqAndPositions()).isEqualTo(field.getOmitTermFreqAndPositions());
        Assertions.assertThat((boolean)copy.isBinary()).isEqualTo(field.isBinary());
        Assertions.assertThat((boolean)copy.isIndexed()).isEqualTo(field.isIndexed());
        Assertions.assertThat((boolean)copy.isLazy()).isEqualTo(field.isLazy());
        Assertions.assertThat((boolean)copy.isStoreOffsetWithTermVector()).isEqualTo(field.isStoreOffsetWithTermVector());
        Assertions.assertThat((boolean)copy.isStorePositionWithTermVector()).isEqualTo(field.isStorePositionWithTermVector());
        Assertions.assertThat((boolean)copy.isStored()).isEqualTo(field.isStored());
        Assertions.assertThat((boolean)copy.isTokenized()).isEqualTo(field.isTokenized());
        Assertions.assertThat((boolean)this.compareReaders(copy.readerValue(), field.readerValue())).isTrue();
        Assertions.assertThat((boolean)this.compareTokenStreams(field.tokenStreamValue(), copy.tokenStreamValue())).isTrue();
        Assertions.assertThat((String)copy.stringValue()).isEqualTo((Object)field.stringValue());
        Assertions.assertThat((boolean)copy.isTermVectorStored()).isEqualTo(field.isTermVectorStored());
    }

    private boolean compareTokenStreams(TokenStream original, TokenStream copy) {
        if (original == null) {
            return copy == null;
        }
        try {
            original.reset();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SerializableTokenStream serOriginal = CopyTokenStream.buildSerializabletokenStream((TokenStream)original);
        SerializableTokenStream serCopy = CopyTokenStream.buildSerializabletokenStream((TokenStream)copy);
        if (serOriginal.getStream().size() != serCopy.getStream().size()) {
            return false;
        }
        int i = 0;
        while (i < serOriginal.getStream().size()) {
            List origToken = (List)serOriginal.getStream().get(i);
            List copyToken = (List)serCopy.getStream().get(i);
            if (origToken.size() != copyToken.size()) {
                return false;
            }
            int j = 0;
            while (j < origToken.size()) {
                AttributeImpl origAttr = (AttributeImpl)origToken.get(j);
                AttributeImpl copyAttr = (AttributeImpl)copyToken.get(j);
                if (origAttr.getClass() != copyAttr.getClass()) {
                    return false;
                }
                this.testAttributeTypes(origAttr, copyAttr);
                ++j;
            }
            ++i;
        }
        return true;
    }

    private void testAttributeTypes(AttributeImpl origAttr, AttributeImpl copyAttr) {
        if (origAttr instanceof AnalysisRequestHandlerBase.TokenTrackingAttributeImpl) {
            Assertions.assertThat((int[])((AnalysisRequestHandlerBase.TokenTrackingAttributeImpl)origAttr).getPositions()).isEqualTo(((AnalysisRequestHandlerBase.TokenTrackingAttributeImpl)copyAttr).getPositions());
        } else if (origAttr instanceof CharTermAttribute) {
            Assertions.assertThat((String)origAttr.toString()).isEqualTo((Object)copyAttr.toString());
        } else if (origAttr instanceof PayloadAttribute) {
            Assertions.assertThat((Object)((PayloadAttribute)origAttr).getPayload()).isEqualTo((Object)((PayloadAttribute)copyAttr).getPayload());
        } else if (origAttr instanceof KeywordAttribute) {
            Assertions.assertThat((boolean)((KeywordAttribute)origAttr).isKeyword()).isEqualTo(((KeywordAttribute)copyAttr).isKeyword());
        } else if (origAttr instanceof PositionIncrementAttribute) {
            Assertions.assertThat((int)((PositionIncrementAttribute)origAttr).getPositionIncrement()).isEqualTo(((PositionIncrementAttribute)copyAttr).getPositionIncrement());
        } else if (origAttr instanceof FlagsAttribute) {
            Assertions.assertThat((int)((FlagsAttribute)origAttr).getFlags()).isEqualTo(((FlagsAttribute)copyAttr).getFlags());
        } else if (origAttr instanceof TypeAttribute) {
            Assertions.assertThat((String)((TypeAttribute)origAttr).type()).isEqualTo((Object)((TypeAttribute)copyAttr).type());
        } else if (origAttr instanceof OffsetAttribute) {
            OffsetAttribute orig = (OffsetAttribute)origAttr;
            OffsetAttribute cop = (OffsetAttribute)copyAttr;
            Assertions.assertThat((int)orig.startOffset()).isEqualTo(cop.startOffset());
            Assertions.assertThat((int)orig.endOffset()).isEqualTo(cop.endOffset());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean compareReaders(Reader copy, Reader original) {
        if (original == null) {
            return copy == null;
        }
        try {
            int o = original.read();
            while (true) {
                if (o == -1) {
                    return copy.read() == -1;
                }
                int c = copy.read();
                if (o != c) {
                    return false;
                }
                o = original.read();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void assertNumericField(NumericField field, NumericField copy) {
        Assertions.assertThat((String)copy.name()).isEqualTo((Object)field.name());
        Assertions.assertThat((int)copy.getBinaryLength()).isEqualTo(field.getBinaryLength());
        Assertions.assertThat((int)copy.getBinaryOffset()).isEqualTo(field.getBinaryOffset());
        Assertions.assertThat((byte[])copy.getBinaryValue()).isEqualTo(field.getBinaryValue());
        Assertions.assertThat((float)copy.getBoost()).isEqualTo(field.getBoost());
        Assertions.assertThat((Object)copy.getDataType()).isEqualTo((Object)field.getDataType());
        Assertions.assertThat((Object)copy.getNumericValue()).isEqualTo((Object)field.getNumericValue());
        Assertions.assertThat((boolean)copy.getOmitNorms()).isEqualTo(field.getOmitNorms());
        Assertions.assertThat((boolean)copy.getOmitTermFreqAndPositions()).isEqualTo(field.getOmitTermFreqAndPositions());
        Assertions.assertThat((int)copy.getPrecisionStep()).isEqualTo(field.getPrecisionStep());
        Assertions.assertThat((boolean)copy.isBinary()).isEqualTo(field.isBinary());
        Assertions.assertThat((boolean)copy.isIndexed()).isEqualTo(field.isIndexed());
        Assertions.assertThat((boolean)copy.isLazy()).isEqualTo(field.isLazy());
        Assertions.assertThat((boolean)copy.isStoreOffsetWithTermVector()).isEqualTo(field.isStoreOffsetWithTermVector());
        Assertions.assertThat((boolean)copy.isStorePositionWithTermVector()).isEqualTo(field.isStorePositionWithTermVector());
        Assertions.assertThat((boolean)copy.isStored()).isEqualTo(field.isStored());
        Assertions.assertThat((boolean)copy.isTokenized()).isEqualTo(field.isTokenized());
        Assertions.assertThat((Object)copy.readerValue()).isEqualTo((Object)field.readerValue());
        Assertions.assertThat((Object)copy.tokenStreamValue()).isEqualTo((Object)field.tokenStreamValue());
        Assertions.assertThat((String)copy.stringValue()).isEqualTo((Object)field.stringValue());
    }

    private void assertDelete(DeleteLuceneWork work, DeleteLuceneWork copy) {
        ((ObjectAssert)Assertions.assertThat((Object)work.getEntityClass()).as("Delete.getEntityClass is not copied")).isEqualTo((Object)copy.getEntityClass());
        ((ObjectAssert)Assertions.assertThat((Object)work.getId()).as("Delete.getId is not copied")).isEqualTo((Object)copy.getId());
        ((ObjectAssert)Assertions.assertThat((Object)work.getDocument()).as("Delete.getDocument is not the same")).isEqualTo((Object)copy.getDocument());
        ((StringAssert)Assertions.assertThat((String)work.getIdInString()).as("Delete.getIdInString is not the same")).isEqualTo((Object)copy.getIdInString());
        ((MapAssert)Assertions.assertThat((Map)work.getFieldToAnalyzerMap()).as("Delete.getFieldToAnalyzerMap is not the same")).isEqualTo((Object)copy.getFieldToAnalyzerMap());
    }

    private void assertPurgeAll(PurgeAllLuceneWork work, PurgeAllLuceneWork copy) {
        ((ObjectAssert)Assertions.assertThat((Object)work.getEntityClass()).as("PurgeAllLuceneWork.getEntityClass is not copied")).isEqualTo((Object)copy.getEntityClass());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{RemoteEntity.class};
    }

    private static class SerializableStringReader
    extends Reader
    implements Serializable {
        private boolean read = false;

        private SerializableStringReader() {
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.read) {
                return -1;
            }
            this.read = true;
            cbuf[off] = 2;
            return 1;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

