/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.session;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.queryParser.QueryParser;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.jdbc.Work;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.impl.FullTextSessionImpl;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.session.Domain;
import org.hibernate.search.test.session.Email;

public class MassIndexUsingManualFlushTest
extends SearchTestCase {
    public void testManualIndexFlush() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        int loop = 14;
        s.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                int i = 0;
                while (i < 14) {
                    Statement statmt = connection.createStatement();
                    statmt.executeUpdate("insert into Domain(id, name) values( + " + (i + 1) + ", 'sponge" + i + "')");
                    statmt.executeUpdate("insert into Email(id, title, body, header, domain_id) values( + " + (i + 1) + ", 'Bob Sponge', 'Meet the guys who create the software', 'nope', " + (i + 1) + ")");
                    statmt.close();
                    ++i;
                }
            }
        });
        tx.commit();
        s.close();
        s = new FullTextSessionImpl(this.openSession());
        tx = s.beginTransaction();
        ScrollableResults results = s.createCriteria(Email.class).scroll(ScrollMode.FORWARD_ONLY);
        int index = 0;
        while (results.next()) {
            Email o = (Email)results.get(0);
            s.index((Object)o);
            if (++index % 5 != 0) continue;
            s.flushToIndexes();
            s.clear();
        }
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.stopAnalyzer);
        List result = s.createFullTextQuery(parser.parse("body:create"), new Class[0]).list();
        MassIndexUsingManualFlushTest.assertEquals((int)14, (int)result.size());
        for (Object object : result) {
            s.delete(object);
        }
        tx.commit();
        s.close();
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.analyzer", StopAnalyzer.class.getName());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Email.class, Domain.class};
    }
}

