/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.session;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionContract;
import org.hibernate.cfg.Configuration;
import org.hibernate.context.internal.ThreadLocalSessionContext;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.spi.TransactionContext;
import org.hibernate.event.spi.EventSource;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.session.DelegationWrapper;
import org.hibernate.search.test.session.Domain;
import org.hibernate.search.test.session.Email;

public class SessionTest
extends SearchTestCase {
    private static final Class[] SESS_PROXY_INTERFACES = new Class[]{Session.class, TransactionContext.class, LobCreationContext.class, EventSource.class, SessionImplementor.class, SharedSessionContract.class};

    public void testSessionWrapper() throws Exception {
        Session s = this.openSession();
        DelegationWrapper wrapper = new DelegationWrapper(s);
        Session wrapped = (Session)Proxy.newProxyInstance(Session.class.getClassLoader(), SESS_PROXY_INTERFACES, (InvocationHandler)wrapper);
        try {
            Search.getFullTextSession((Session)wrapped);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            SessionTest.fail((String)e.toString());
        }
        wrapped.close();
    }

    public void testDetachedCriteria() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        DetachedCriteria dc = DetachedCriteria.forClass(Email.class);
        try {
            Criteria c = dc.getExecutableCriteria((Session)s).setMaxResults(10);
            c.list();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            SessionTest.fail((String)e.toString());
        }
        s.close();
    }

    public void testThreadBoundSessionWrappingOutOfTransaction() throws Exception {
        Session session = this.getSessions().getCurrentSession();
        try {
            FullTextSession fts = Search.getFullTextSession((Session)session);
        }
        finally {
            ThreadLocalSessionContext.unbind((SessionFactory)this.getSessions());
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Email.class, Domain.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.connection.autocommit", "true");
        cfg.setProperty("hibernate.current_session_context_class", "thread");
    }
}

