/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.shards;

import junit.framework.Assert;
import org.apache.lucene.index.IndexReader;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.indexes.IndexReaderAccessor;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.shards.Product;
import org.hibernate.search.test.shards.ProductsAvailabilityShardingStrategy;

public class DirectorySelectionTest
extends SearchTestCase {
    private IndexReaderAccessor indexReaderAccessor;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        FullTextSession fts = this.indexData();
        this.indexReaderAccessor = fts.getSearchFactory().getIndexReaderAccessor();
    }

    public void testDirectoryProviderForQuery() throws Exception {
        IndexReader indexReader = this.indexReaderAccessor.open(new Class[]{Product.class});
        try {
            Assert.assertEquals((int)2, (int)indexReader.numDocs());
        }
        finally {
            this.indexReaderAccessor.close(indexReader);
        }
        indexReader = this.indexReaderAccessor.open(new String[]{"Products.0"});
        try {
            Assert.assertEquals((int)1, (int)indexReader.numDocs());
        }
        finally {
            this.indexReaderAccessor.close(indexReader);
        }
        indexReader = this.indexReaderAccessor.open(new String[]{"Products.1"});
        try {
            Assert.assertEquals((int)1, (int)indexReader.numDocs());
        }
        finally {
            this.indexReaderAccessor.close(indexReader);
        }
    }

    public void testOpeningIndexReaderByUnknownNameThrowsException() throws Exception {
        try {
            this.indexReaderAccessor.open(new String[]{"Products.1", "hoa?"});
            Assert.fail((String)"should have failed");
        }
        catch (SearchException se) {
            Assert.assertEquals((String)"HSEARCH000107: Index names hoa? is not defined", (String)se.getMessage());
        }
    }

    public void testOpeningIndexReaderUsingEmptyStringArrayThrowsException() throws Exception {
        try {
            this.indexReaderAccessor.open(new String[0]);
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"HSEARCH000111: At least one index name must be provided: can't open an IndexReader on nothing", (String)e.getMessage());
        }
    }

    public void testOpeningIndexReaderUsingNullAsNameThrowsException() throws Exception {
        try {
            this.indexReaderAccessor.open(new String[]{null});
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"HSEARCH000111: At least one index name must be provided: can't open an IndexReader on nothing", (String)e.getMessage());
        }
    }

    public void testOpeningIndexReaderByUnknownEntityThrowsException() throws Exception {
        try {
            this.indexReaderAccessor.open(new Class[]{((Object)((Object)this)).getClass()});
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"HSEARCH000109: org.hibernate.search.test.shards.DirectorySelectionTest is not an indexed type", (String)e.getMessage());
        }
    }

    public void testOpeningIndexReaderUsingEmptyClassArrayThrowsException() throws Exception {
        try {
            this.indexReaderAccessor.open(new Class[0]);
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"HSEARCH000112: At least one entity type must be provided: can't open an IndexReader on nothing", (String)e.getMessage());
        }
    }

    public void testOpeningIndexReaderUsingNullAsClassThrowsException() throws Exception {
        try {
            this.indexReaderAccessor.open(new Class[]{null});
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"HSEARCH000110: 'null' is not a valid indexed type", (String)e.getMessage());
        }
    }

    private FullTextSession indexData() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Product p1 = new Product();
        p1.setName("The Definitive ANTLR Reference: Building Domain-Specific Languages");
        p1.setAvailable(true);
        s.persist((Object)p1);
        Product p2 = new Product();
        p2.setName("Recipes for distributed cloud applications using Infinispan");
        p2.setAvailable(false);
        s.persist((Object)p2);
        tx.commit();
        s.clear();
        FullTextSession fts = Search.getFullTextSession((Session)s);
        fts.close();
        return fts;
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.Products.sharding_strategy", ProductsAvailabilityShardingStrategy.class.getCanonicalName());
        cfg.setProperty("hibernate.search.Products.sharding_strategy.nbr_of_shards", "2");
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Product.class};
    }
}

