/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.impl.Helper;
import org.hibernate.search.batchindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.batchindexing.impl.StatelessSessionAwareRunnable;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class IdentifierProducer
implements StatelessSessionAwareRunnable {
    private static final Log log = LoggerFactory.make();
    private final ProducerConsumerQueue<List<Serializable>> destination;
    private final SessionFactory sessionFactory;
    private final int batchSize;
    private final Class<?> indexedType;
    private final MassIndexerProgressMonitor monitor;
    private final long objectsLimit;
    private final ErrorHandler errorHandler;
    private final int idFetchSize;

    public IdentifierProducer(ProducerConsumerQueue<List<Serializable>> fromIdentifierListToEntities, SessionFactory sessionFactory, int objectLoadingBatchSize, Class<?> indexedType, MassIndexerProgressMonitor monitor, long objectsLimit, ErrorHandler errorHandler, int idFetchSize) {
        this.destination = fromIdentifierListToEntities;
        this.sessionFactory = sessionFactory;
        this.batchSize = objectLoadingBatchSize;
        this.indexedType = indexedType;
        this.monitor = monitor;
        this.objectsLimit = objectsLimit;
        this.errorHandler = errorHandler;
        this.idFetchSize = idFetchSize;
        log.trace((Object)"created");
    }

    @Override
    public void run(StatelessSession upperSession) {
        block5: {
            log.trace((Object)"started");
            try {
                try {
                    this.inTransactionWrapper(upperSession);
                }
                catch (Throwable e) {
                    this.errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), e);
                    this.destination.producerStopping();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.destination.producerStopping();
                throw throwable;
            }
            this.destination.producerStopping();
        }
        log.trace((Object)"finished");
    }

    private void inTransactionWrapper(StatelessSession upperSession) throws Exception {
        StatelessSession session = upperSession;
        if (upperSession == null) {
            session = this.sessionFactory.openStatelessSession();
        }
        try {
            try {
                Transaction transaction = Helper.getTransactionAndMarkForJoin(session);
                transaction.begin();
                this.loadAllIdentifiers(session);
                transaction.commit();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (upperSession == null) {
                    session.close();
                }
            }
        }
        finally {
            if (upperSession == null) {
                session.close();
            }
        }
    }

    private void loadAllIdentifiers(StatelessSession session) throws InterruptedException {
        Number countAsNumber = (Number)session.createCriteria(this.indexedType).setProjection(Projections.rowCount()).setCacheable(false).uniqueResult();
        long totalCount = countAsNumber.longValue();
        if (this.objectsLimit != 0L && this.objectsLimit < totalCount) {
            totalCount = this.objectsLimit;
        }
        if (log.isDebugEnabled()) {
            log.debugf("going to fetch %d primary keys", (Object)totalCount);
        }
        this.monitor.addToTotalCount(totalCount);
        Criteria criteria = session.createCriteria(this.indexedType).setProjection((Projection)Projections.id()).setCacheable(false).setFetchSize(this.idFetchSize);
        ScrollableResults results = criteria.scroll(ScrollMode.FORWARD_ONLY);
        ArrayList<Serializable> destinationList = new ArrayList<Serializable>(this.batchSize);
        long counter = 0L;
        try {
            while (results.next()) {
                Serializable id = (Serializable)results.get(0);
                destinationList.add(id);
                if (destinationList.size() == this.batchSize) {
                    this.enqueueList(destinationList);
                    destinationList = new ArrayList(this.batchSize);
                }
                if (++counter != totalCount) continue;
                break;
            }
        }
        finally {
            results.close();
        }
        this.enqueueList(destinationList);
    }

    private void enqueueList(List<Serializable> idsList) throws InterruptedException {
        if (!idsList.isEmpty()) {
            this.destination.put(idsList);
            log.tracef("produced a list of ids %s", idsList);
        }
    }
}

