/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.ObjectsInitializer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class CriteriaObjectsInitializer
implements ObjectsInitializer {
    private static final Log log = LoggerFactory.make();
    private static final int MAX_IN_CLAUSE = 500;
    public static final CriteriaObjectsInitializer INSTANCE = new CriteriaObjectsInitializer();

    private CriteriaObjectsInitializer() {
    }

    @Override
    public void initializeObjects(EntityInfo[] entityInfos, Criteria criteria, Class<?> entityType, SearchFactoryImplementor searchFactoryImplementor, TimeoutManager timeoutManager, Session session) {
        Long timeLeftInSecond;
        boolean exact;
        int maxResults = entityInfos.length;
        if (log.isTraceEnabled()) {
            log.tracef("Load %d objects using criteria queries", (Object)maxResults);
        }
        if (maxResults == 0) {
            return;
        }
        if (criteria == null) {
            criteria = session.createCriteria(entityType);
        }
        Set indexedEntities = searchFactoryImplementor.getIndexedTypesPolymorphic(new Class[]{entityType});
        DocumentBuilderIndexedEntity builder = searchFactoryImplementor.getIndexBindingForEntity((Class)indexedEntities.iterator().next()).getDocumentBuilder();
        String idName = builder.getIdentifierName();
        Disjunction disjunction = Restrictions.disjunction();
        int loop = maxResults / 500;
        boolean bl = exact = maxResults % 500 == 0;
        if (!exact) {
            ++loop;
        }
        int index = 0;
        while (index < loop) {
            int max = index * 500 + 500 <= maxResults ? index * 500 + 500 : maxResults;
            ArrayList<Serializable> ids = new ArrayList<Serializable>(max - index * 500);
            int entityInfoIndex = index * 500;
            while (entityInfoIndex < max) {
                ids.add(entityInfos[entityInfoIndex].getId());
                ++entityInfoIndex;
            }
            disjunction.add(Restrictions.in((String)idName, ids));
            ++index;
        }
        criteria.add((Criterion)disjunction);
        if (timeoutManager.getType() != TimeoutManager.Type.LIMIT && (timeLeftInSecond = timeoutManager.getTimeoutLeftInSeconds()) != null) {
            if (timeLeftInSecond == 0L) {
                timeoutManager.reactOnQueryTimeoutExceptionWhileExtracting(null);
            }
            criteria.setTimeout(timeLeftInSecond.intValue());
        }
        criteria.list();
    }
}

