/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.common.util.ReflectHelper;

public class LoaderHelper {
    private static final List<Class> objectNotFoundExceptions = new ArrayList<Class>(2);

    static {
        try {
            objectNotFoundExceptions.add(ReflectHelper.classForName((String)"org.hibernate.ObjectNotFoundException"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            objectNotFoundExceptions.add(ReflectHelper.classForName((String)"javax.persistence.EntityNotFoundException"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private LoaderHelper() {
    }

    public static boolean isObjectNotFoundException(RuntimeException e) {
        boolean objectNotFound = false;
        Class<?> exceptionClass = e.getClass();
        for (Class clazz : objectNotFoundExceptions) {
            if (!clazz.isAssignableFrom(exceptionClass)) continue;
            objectNotFound = true;
            break;
        }
        return objectNotFound;
    }
}

