/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderHelper;
import org.hibernate.search.query.hibernate.impl.ObjectsInitializer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LookupObjectsInitializer
implements ObjectsInitializer {
    private static final Log log = LoggerFactory.make();
    public static final LookupObjectsInitializer INSTANCE = new LookupObjectsInitializer();

    private LookupObjectsInitializer() {
    }

    @Override
    public void initializeObjects(EntityInfo[] entityInfos, Criteria criteria, Class<?> entityType, SearchFactoryImplementor searchFactoryImplementor, TimeoutManager timeoutManager, Session session) {
        boolean traceEnabled = log.isTraceEnabled();
        int maxResults = entityInfos.length;
        if (maxResults == 0) {
            if (traceEnabled) {
                log.tracef("No object to initialize", (Object)maxResults);
            }
            return;
        }
        EntityInfo[] entityInfoArray = entityInfos;
        int n = entityInfos.length;
        int n2 = 0;
        while (n2 < n) {
            EntityInfo entityInfo = entityInfoArray[n2];
            ObjectLoaderHelper.load(entityInfo, session);
            ++n2;
        }
        if (traceEnabled) {
            log.tracef("Initialized %d objects by lookup method.", (Object)maxResults);
        }
    }
}

