/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test;

import java.io.File;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.TestCase;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.store.Directory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.jdbc.Work;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.fwk.SkipLog;
import org.hibernate.search.util.impl.ContextHelper;
import org.hibernate.search.util.impl.FileHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.hibernate.testing.FailureExpected;
import org.hibernate.testing.SkipForDialect;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.junit.After;
import org.junit.Before;

public abstract class SearchTestCase
extends TestCase {
    private static final Log log = LoggerFactory.make();
    private SessionFactory sessions;
    protected Session session;
    private SearchFactoryImplementor searchFactory;
    protected Configuration cfg;
    private static Class<?> lastTestClass;

    @Before
    public void setUp() throws Exception {
        if (this.cfg == null || lastTestClass != ((Object)((Object)this)).getClass()) {
            this.buildConfiguration();
        }
        lastTestClass = ((Object)((Object)this)).getClass();
        this.openSessionFactory();
    }

    protected void openSessionFactory() {
        if (this.sessions == null) {
            if (this.cfg == null) {
                throw new IllegalStateException("configuration was not built");
            }
        } else {
            throw new IllegalStateException("there should be no SessionFactory initialized at this point");
        }
        this.setSessions(this.cfg.buildSessionFactory());
    }

    protected void closeSessionFactory() {
        if (this.sessions == null) {
            throw new IllegalStateException("there is no SessionFactory to close");
        }
        this.sessions.close();
        this.sessions = null;
    }

    protected void handleUnclosedResources() {
        if (this.session != null && this.session.isOpen()) {
            if (this.session.isConnected()) {
                this.session.doWork((Work)new RollbackWork());
            }
            this.session.close();
            this.session = null;
            log.debug((Object)"Closing open session. Make sure to close sessions explicitly in your tests!");
        } else {
            this.session = null;
        }
    }

    protected void closeResources() {
    }

    protected String[] getXmlFiles() {
        return new String[0];
    }

    protected void setCfg(Configuration cfg) {
        this.cfg = cfg;
    }

    protected Configuration getCfg() {
        return this.cfg;
    }

    public Session openSession() throws HibernateException {
        this.session = this.getSessions().openSession();
        return this.session;
    }

    protected void setSessions(SessionFactory sessions) {
        this.sessions = sessions;
    }

    protected SessionFactory getSessions() {
        if (this.cfg == null) {
            throw new IllegalStateException("Configuration should be already defined at this point");
        }
        if (this.sessions == null) {
            throw new IllegalStateException("SessionFactory should be already defined at this point");
        }
        return this.sessions;
    }

    protected void configure(Configuration cfg) {
        cfg.setProperty("hibernate.search.lucene_version", TestConstants.getTargetLuceneVersion().name());
        cfg.setProperty("hibernate.search.default.directory_provider", "ram");
        cfg.setProperty("hibernate.search.default.indexBase", this.getBaseIndexDir().getAbsolutePath());
        cfg.setProperty("hibernate.search.analyzer", StopAnalyzer.class.getName());
        cfg.setProperty("hibernate.search.default.indexwriter.merge_factor", "100");
        cfg.setProperty("hibernate.search.default.indexwriter.max_buffered_docs", "1000");
    }

    protected Directory getDirectory(Class<?> clazz) {
        SearchFactoryImplementor searchFactoryBySFI = ContextHelper.getSearchFactoryBySFI((SessionFactoryImplementor)((SessionFactoryImplementor)this.sessions));
        IndexManager[] indexManagers = searchFactoryBySFI.getIndexBindingForEntity(clazz).getIndexManagers();
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexManagers[0];
        return indexManager.getDirectoryProvider().getDirectory();
    }

    @After
    public void tearDown() throws Exception {
        this.handleUnclosedResources();
        this.closeResources();
        this.closeSessionFactory();
        this.ensureIndexesAreEmpty();
    }

    protected abstract Class<?>[] getAnnotatedClasses();

    protected boolean recreateSchema() {
        return true;
    }

    protected void runSchemaGeneration() {
        SchemaExport export = new SchemaExport(this.cfg);
        export.create(true, true);
    }

    protected void runSchemaDrop() {
        SchemaExport export = new SchemaExport(this.cfg);
        export.drop(true, true);
    }

    protected void ensureIndexesAreEmpty() {
        if ("jms".equals(this.getCfg().getProperty("hibernate.search.worker.backend"))) {
            log.debug((Object)"JMS based test. Skipping index emptying");
            return;
        }
        FileHelper.delete((File)this.getBaseIndexDir());
    }

    protected SearchFactory getSearchFactory() {
        if (this.searchFactory == null) {
            Session session = this.openSession();
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            this.searchFactory = (SearchFactoryImplementor)fullTextSession.getSearchFactory();
            fullTextSession.close();
        }
        return this.searchFactory;
    }

    protected File getBaseIndexDir() {
        String shortTestName = ((Object)((Object)this)).getClass().getSimpleName() + "." + this.getName();
        File indexPath = new File(TestConstants.getIndexDirectory(), shortTestName);
        return indexPath;
    }

    protected void buildConfiguration() {
        if (this.cfg != null) {
            throw new IllegalStateException("Configuration was already built");
        }
        try {
            this.setCfg(new Configuration());
            this.configure(this.cfg);
            if (this.recreateSchema()) {
                this.cfg.setProperty("hibernate.hbm2ddl.auto", "create-drop");
            }
            for (String aPackage : this.getAnnotatedPackages()) {
                this.getCfg().addPackage(aPackage);
            }
            for (Class<?> aClass : this.getAnnotatedClasses()) {
                this.getCfg().addAnnotatedClass((Class)aClass);
            }
            for (String xmlFile : this.getXmlFiles()) {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlFile);
                this.getCfg().addInputStream(is);
            }
        }
        catch (HibernateException e) {
            e.printStackTrace();
            throw e;
        }
        catch (SearchException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected String[] getAnnotatedPackages() {
        return new String[0];
    }

    protected SearchFactoryImplementor getSearchFactoryImpl() {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        s.close();
        SearchFactory searchFactory = s.getSearchFactory();
        return (SearchFactoryImplementor)searchFactory;
    }

    private void reportSkip(Skip skip) {
        this.reportSkip(skip.reason, skip.testDescription);
    }

    protected void reportSkip(String reason, String testDescription) {
        StringBuilder builder = new StringBuilder();
        builder.append("*** skipping test [");
        builder.append(this.fullTestName());
        builder.append("] - ");
        builder.append(testDescription);
        builder.append(" : ");
        builder.append(reason);
        SkipLog.LOG.warn(builder.toString());
    }

    protected Dialect getDialect() {
        return Dialect.getDialect();
    }

    protected Skip buildSkip(Dialect dialect, String comment, String jiraKey) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("skipping database-specific test [");
        buffer.append(this.fullTestName());
        buffer.append("] for dialect [");
        buffer.append(dialect.getClass().getName());
        buffer.append(']');
        if (StringHelper.isNotEmpty((String)comment)) {
            buffer.append("; ").append(comment);
        }
        if (StringHelper.isNotEmpty((String)jiraKey)) {
            buffer.append(" (").append(jiraKey).append(')');
        }
        return new Skip(buffer.toString(), null);
    }

    protected <T extends Annotation> T locateAnnotation(Class<T> annotationClass, Method runMethod) {
        T annotation = runMethod.getAnnotation(annotationClass);
        if (annotation == null) {
            annotation = ((Object)((Object)this)).getClass().getAnnotation(annotationClass);
        }
        if (annotation == null) {
            annotation = runMethod.getDeclaringClass().getAnnotation(annotationClass);
        }
        return annotation;
    }

    protected final Skip determineSkipByDialect(Dialect dialect, Method runMethod) throws Exception {
        SkipForDialect skipForDialectAnn = this.locateAnnotation(SkipForDialect.class, runMethod);
        if (skipForDialectAnn != null) {
            for (Class dialectClass : skipForDialectAnn.value()) {
                if (!(skipForDialectAnn.strictMatching() ? dialectClass.equals(dialect.getClass()) : dialectClass.isInstance(dialect))) continue;
                return this.buildSkip(dialect, skipForDialectAnn.comment(), skipForDialectAnn.jiraKey());
            }
        }
        return null;
    }

    protected void runTest() throws Throwable {
        Method runMethod = this.findTestMethod();
        FailureExpected failureExpected = this.locateAnnotation(FailureExpected.class, runMethod);
        try {
            super.runTest();
            if (failureExpected != null) {
                throw new FailureExpectedTestPassedException();
            }
        }
        catch (FailureExpectedTestPassedException t) {
            this.closeResources();
            throw t;
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            if (t instanceof IllegalAccessException) {
                t.fillInStackTrace();
            }
            this.closeResources();
            if (failureExpected != null) {
                StringBuilder builder = new StringBuilder();
                if (StringHelper.isNotEmpty((String)failureExpected.message())) {
                    builder.append(failureExpected.message());
                } else {
                    builder.append("ignoring @FailureExpected test");
                }
                builder.append(" (").append(failureExpected.jiraKey()).append(")");
                SkipLog.LOG.warn(builder.toString(), t);
            }
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        Method runMethod = this.findTestMethod();
        Skip skip = this.determineSkipByDialect(Dialect.getDialect(), runMethod);
        if (skip != null) {
            this.reportSkip(skip);
            return;
        }
        this.setUp();
        try {
            this.runTest();
        }
        finally {
            this.tearDown();
        }
    }

    public String fullTestName() {
        return ((Object)((Object)this)).getClass().getName() + "#" + this.getName();
    }

    private Method findTestMethod() {
        String fName = this.getName();
        SearchTestCase.assertNotNull((Object)fName);
        Method runMethod = null;
        try {
            runMethod = ((Object)((Object)this)).getClass().getMethod(fName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            SearchTestCase.fail((String)("Method \"" + fName + "\" not found"));
        }
        if (!Modifier.isPublic(runMethod.getModifiers())) {
            SearchTestCase.fail((String)("Method \"" + fName + "\" should be public"));
        }
        return runMethod;
    }

    private static class FailureExpectedTestPassedException
    extends Exception {
        public FailureExpectedTestPassedException() {
            super("Test marked as @FailureExpected, but did not fail!");
        }
    }

    protected static class Skip {
        private final String reason;
        private final String testDescription;

        public Skip(String reason, String testDescription) {
            this.reason = reason;
            this.testDescription = testDescription;
        }
    }

    private static class RollbackWork
    implements Work {
        private RollbackWork() {
        }

        public void execute(Connection connection) throws SQLException {
            connection.rollback();
        }
    }
}

