/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.solr;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.Version;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.analyzer.AnalyzerTest;
import org.hibernate.search.test.analyzer.solr.Team;
import org.hibernate.search.util.AnalyzerUtils;

public class SolrAnalyzerTest
extends SearchTestCase {
    public void testAnalyzerDef() throws Exception {
        Team team = new Team();
        team.setDescription("This is a D\u00e0scription");
        team.setLocation("Atlanta");
        team.setName("ATL team");
        FullTextSession fts = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fts.beginTransaction();
        fts.persist((Object)team);
        tx.commit();
        fts.clear();
        tx = fts.beginTransaction();
        TermQuery query = new TermQuery(new Term("description", "D\u00e0scription"));
        SolrAnalyzerTest.assertEquals((String)"iso latin filter should work.  \ufffd should be a now", (int)0, (int)fts.createFullTextQuery((Query)query, new Class[0]).list().size());
        query = new TermQuery(new Term("description", "is"));
        SolrAnalyzerTest.assertEquals((String)"stop word filter should work. is should be removed", (int)0, (int)fts.createFullTextQuery((Query)query, new Class[0]).list().size());
        query = new TermQuery(new Term("description", "dascript"));
        SolrAnalyzerTest.assertEquals((String)"snowball stemmer should work. 'dascription' should be stemmed to 'dascript'", (int)1, (int)fts.createFullTextQuery((Query)query, new Class[0]).list().size());
        fts.delete(fts.createFullTextQuery((Query)query, new Class[0]).list().get(0));
        tx.commit();
        fts.close();
    }

    public void testAnalyzers() throws Exception {
        FullTextSession fts = Search.getFullTextSession((Session)this.openSession());
        Analyzer analyzer = fts.getSearchFactory().getAnalyzer("standard_analyzer");
        String text = "This is just FOOBAR's";
        Token[] tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"This", "is", "just", "FOOBAR"});
        analyzer = fts.getSearchFactory().getAnalyzer("html_standard_analyzer");
        text = "This is <b>foo</b><i>bar's</i>";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"This", "is", "foo", "bar"});
        analyzer = fts.getSearchFactory().getAnalyzer("html_whitespace_analyzer");
        text = "This is <b>foo</b><i>bar's</i>";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"This", "is", "foo", "bar's"});
        analyzer = fts.getSearchFactory().getAnalyzer("trim_analyzer");
        text = " Kittens!   ";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"kittens"});
        analyzer = fts.getSearchFactory().getAnalyzer("length_analyzer");
        text = "ab abc abcd abcde abcdef";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"abc", "abcd", "abcde"});
        analyzer = fts.getSearchFactory().getAnalyzer("length_analyzer");
        text = "ab abc abcd abcde abcdef";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"abc", "abcd", "abcde"});
        analyzer = fts.getSearchFactory().getAnalyzer("porter_analyzer");
        text = "bikes bikes biking";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"bike", "bike", "bike"});
        analyzer = fts.getSearchFactory().getAnalyzer("word_analyzer");
        text = "CamelCase";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"Camel", "Case"});
        analyzer = fts.getSearchFactory().getAnalyzer("synonym_analyzer");
        text = "ipod cosmos";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"ipod", "i-pod", "universe", "cosmos"});
        analyzer = fts.getSearchFactory().getAnalyzer("shingle_analyzer");
        text = "please divide this sentence into shingles";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"please", "please divide", "divide", "divide this", "this", "this sentence", "sentence", "sentence into", "into", "into shingles", "shingles"});
        analyzer = fts.getSearchFactory().getAnalyzer("phonetic_analyzer");
        text = "The quick brown fox jumped over the lazy dogs";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        AnalyzerUtils.displayTokens((Analyzer)analyzer, (String)"name", (String)text);
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"0", "KK", "BRN", "FKS", "JMPT", "OFR", "0", "LS", "TKS"});
        analyzer = fts.getSearchFactory().getAnalyzer("pattern_analyzer");
        text = "foo,bar";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"foo", "bar"});
        analyzer = fts.getSearchFactory().getAnalyzer("mapping_char_analyzer");
        text = "CORA\u00c7\u00c3O DE MEL\u00c3O";
        tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)text);
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"CORACAO", "DE", "MELAO"});
        fts.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Team.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.lucene_version", Version.LUCENE_30.name());
    }
}

