/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.bridge.BridgeException;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.testing.TestForIssue;

@TestForIssue(jiraKey="1045")
public class BridgeConversionErrorTest
extends SearchTestCase {
    public void testClassBridgeError() throws Exception {
        ClassBridged classBridged = new ClassBridged();
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)classBridged);
        try {
            tx.commit();
            BridgeConversionErrorTest.fail();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            BridgeConversionErrorTest.assertTrue((boolean)(cause instanceof BridgeException));
            String expectedErrorMessage = "Exception while calling bridge#set\n\tclass: org.hibernate.search.test.bridge.BridgeConversionErrorTest$ClassBridged\n\tpath: test";
            BridgeConversionErrorTest.assertEquals((String)"Wrong error message", (String)expectedErrorMessage, (String)cause.getMessage());
        }
    }

    public void testFieldBridgeError() throws Exception {
        SimpleEntity entity = new SimpleEntity("foo");
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)entity);
        try {
            tx.commit();
            BridgeConversionErrorTest.fail();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            BridgeConversionErrorTest.assertTrue((boolean)(cause instanceof BridgeException));
            String expectedErrorMessage = "Exception while calling bridge#set\n\tclass: org.hibernate.search.test.bridge.BridgeConversionErrorTest$SimpleEntity\n\tpath: name";
            BridgeConversionErrorTest.assertEquals((String)"Wrong error message", (String)expectedErrorMessage, (String)cause.getMessage());
        }
    }

    public void testEmbeddedBridgeError() throws Exception {
        SimpleEntity entity = new SimpleEntity(null);
        EmbeddedEntity embedded = new EmbeddedEntity("foo");
        entity.setEmbedded(embedded);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)entity);
        try {
            tx.commit();
            BridgeConversionErrorTest.fail();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            BridgeConversionErrorTest.assertTrue((boolean)(cause instanceof BridgeException));
            String expectedErrorMessage = "Exception while calling bridge#set\n\tclass: org.hibernate.search.test.bridge.BridgeConversionErrorTest$SimpleEntity\n\tpath: embedded.name";
            BridgeConversionErrorTest.assertEquals((String)"Wrong error message", (String)expectedErrorMessage, (String)cause.getMessage());
        }
    }

    public void testEmbeddedEmbeddedBridgeError() throws Exception {
        SimpleEntity entity = new SimpleEntity(null);
        EmbeddedEntity embedded = new EmbeddedEntity(null);
        entity.setEmbedded(embedded);
        embedded.setEmbeddedEmbedded(new EmbeddedEmbeddedEntity("foo"));
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)entity);
        try {
            tx.commit();
            BridgeConversionErrorTest.fail();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            BridgeConversionErrorTest.assertTrue((boolean)(cause instanceof BridgeException));
            String expectedErrorMessage = "Exception while calling bridge#set\n\tclass: org.hibernate.search.test.bridge.BridgeConversionErrorTest$SimpleEntity\n\tpath: embedded.embeddedEmbedded.name";
            BridgeConversionErrorTest.assertEquals((String)"Wrong error message", (String)expectedErrorMessage, (String)cause.getMessage());
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{ClassBridged.class, SimpleEntity.class, EmbeddedEntity.class, EmbeddedEmbeddedEntity.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.analyzer", SimpleAnalyzer.class.getName());
    }

    @Entity
    @Table(name="EMBEDDEDTWICEENTITY")
    public static class EmbeddedEmbeddedEntity {
        @Id
        @GeneratedValue
        private long id;
        @Field
        @FieldBridge(impl=ExceptionThrowingBridge.class)
        private String name;

        public EmbeddedEmbeddedEntity(String name) {
            this.name = name;
        }
    }

    @Entity
    @Table(name="EMBEDDEDENTITY")
    public static class EmbeddedEntity {
        @Id
        @GeneratedValue
        private long id;
        @Field
        @FieldBridge(impl=ExceptionThrowingBridge.class)
        private String name;
        @IndexedEmbedded
        @OneToOne(cascade={CascadeType.ALL})
        private EmbeddedEmbeddedEntity embeddedEmbedded;

        public EmbeddedEntity(String name) {
            this.name = name;
        }

        public void setEmbeddedEmbedded(EmbeddedEmbeddedEntity embedded) {
            this.embeddedEmbedded = embedded;
        }
    }

    @Entity
    @Indexed
    @Table(name="SIMPLEENTITY")
    public static class SimpleEntity {
        @Id
        @GeneratedValue
        private long id;
        @Field
        @FieldBridge(impl=ExceptionThrowingBridge.class)
        private String name;
        @IndexedEmbedded
        @OneToOne(cascade={CascadeType.ALL})
        private EmbeddedEntity embedded;

        public SimpleEntity(String name) {
            this.name = name;
        }

        public void setEmbedded(EmbeddedEntity embedded) {
            this.embedded = embedded;
        }
    }

    @Entity
    @Indexed
    @Table(name="CLASSBRIDGED")
    @ClassBridge(impl=ExceptionThrowingBridge.class, name="test")
    public static class ClassBridged {
        @Id
        @GeneratedValue
        private long id;
    }

    public static class ExceptionThrowingBridge
    implements org.hibernate.search.bridge.FieldBridge {
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            if (value != null) {
                throw new RuntimeException("boom");
            }
        }
    }
}

