/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.mutablefactory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.batchindexing.impl.Executors;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.RAMDirectoryProvider;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.configuration.mutablefactory.A;
import org.hibernate.search.test.configuration.mutablefactory.B;
import org.hibernate.search.test.configuration.mutablefactory.C;
import org.hibernate.search.test.configuration.mutablefactory.generated.Generated;
import org.hibernate.search.test.util.HibernateManualConfiguration;
import org.hibernate.search.test.util.ManualConfiguration;
import org.hibernate.search.test.util.ManualTransactionContext;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;

public class MutableFactoryTest {
    public static final Log log = LoggerFactory.make();

    @Test
    public void testCreateEmptyFactory() throws Exception {
        ManualConfiguration configuration = MutableFactoryTest.getTestConfiguration();
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        sf.close();
    }

    @Test
    public void testAddingClassFullModel() throws Exception {
        ManualConfiguration configuration = MutableFactoryTest.getTestConfiguration();
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        SearchFactoryBuilder builder = new SearchFactoryBuilder();
        sf = builder.currentFactory((SearchFactoryIntegrator)sf).addClass(A.class).buildSearchFactory();
        ManualTransactionContext tc = new ManualTransactionContext();
        MutableFactoryTest.doIndexWork(new A(1, "Emmanuel"), 1, (SearchFactoryIntegrator)sf, tc);
        tc.end();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "name", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("Emmanuel");
        IndexReader indexReader = sf.getIndexReaderAccessor().open(new Class[]{A.class});
        IndexSearcher searcher = new IndexSearcher(indexReader);
        TopDocs hits = searcher.search(luceneQuery, 1000);
        Assert.assertEquals((long)1L, (long)hits.totalHits);
        searcher.close();
        sf.getIndexReaderAccessor().close(indexReader);
        sf = builder.currentFactory((SearchFactoryIntegrator)sf).addClass(B.class).buildSearchFactory();
        tc = new ManualTransactionContext();
        MutableFactoryTest.doIndexWork(new B(1, "Noel"), 1, (SearchFactoryIntegrator)sf, tc);
        tc.end();
        luceneQuery = parser.parse("Noel");
        indexReader = sf.getIndexReaderAccessor().open(new Class[]{B.class});
        searcher = new IndexSearcher(indexReader);
        hits = searcher.search(luceneQuery, 1000);
        Assert.assertEquals((long)1L, (long)hits.totalHits);
        searcher.close();
        sf.getIndexReaderAccessor().close(indexReader);
        sf.close();
    }

    @Test
    public void testAddingClassSimpleAPI() throws Exception {
        ManualConfiguration configuration = MutableFactoryTest.getTestConfiguration();
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        sf.addClasses(new Class[]{A.class});
        ManualTransactionContext tc = new ManualTransactionContext();
        MutableFactoryTest.doIndexWork(new A(1, "Emmanuel"), 1, (SearchFactoryIntegrator)sf, tc);
        tc.end();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "name", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse("Emmanuel");
        IndexReader indexReader = sf.getIndexReaderAccessor().open(new Class[]{A.class});
        IndexSearcher searcher = new IndexSearcher(indexReader);
        TopDocs hits = searcher.search(luceneQuery, 1000);
        Assert.assertEquals((long)1L, (long)hits.totalHits);
        searcher.close();
        sf.getIndexReaderAccessor().close(indexReader);
        sf.addClasses(new Class[]{B.class, C.class});
        tc = new ManualTransactionContext();
        MutableFactoryTest.doIndexWork(new B(1, "Noel"), 1, (SearchFactoryIntegrator)sf, tc);
        MutableFactoryTest.doIndexWork(new C(1, "Vincent"), 1, (SearchFactoryIntegrator)sf, tc);
        tc.end();
        luceneQuery = parser.parse("Noel");
        indexReader = sf.getIndexReaderAccessor().open(new Class[]{B.class});
        searcher = new IndexSearcher(indexReader);
        hits = searcher.search(luceneQuery, 1000);
        Assert.assertEquals((long)1L, (long)hits.totalHits);
        searcher.close();
        sf.getIndexReaderAccessor().close(indexReader);
        luceneQuery = parser.parse("Vincent");
        indexReader = sf.getIndexReaderAccessor().open(new Class[]{C.class});
        searcher = new IndexSearcher(indexReader);
        hits = searcher.search(luceneQuery, 1000);
        Assert.assertEquals((long)1L, (long)hits.totalHits);
        searcher.close();
        sf.getIndexReaderAccessor().close(indexReader);
        sf.close();
    }

    private static void doIndexWork(Object entity, Integer id, SearchFactoryIntegrator sfi, ManualTransactionContext tc) {
        Work work = new Work(entity, (Serializable)id, WorkType.INDEX);
        sfi.getWorker().performWork(work, (TransactionContext)tc);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultiThreadedAddClasses() throws Exception {
        void var9_16;
        boolean inProgress;
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "name", TestConstants.standardAnalyzer);
        ManualConfiguration configuration = MutableFactoryTest.getTestConfiguration();
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        ArrayList<DoAddClasses> runnables = new ArrayList<DoAddClasses>(10);
        int nbrOfThread = 10;
        int nbrOfClassesPerThread = 10;
        for (int i = 0; i < 10; ++i) {
            runnables.add(new DoAddClasses((SearchFactoryIntegrator)sf, i, 10));
        }
        ThreadPoolExecutor poolExecutor = Executors.newFixedThreadPool((int)10, (String)"SFI classes addition");
        poolExecutor.prestartAllCoreThreads();
        for (Runnable runnable : runnables) {
            poolExecutor.execute(runnable);
        }
        poolExecutor.shutdown();
        do {
            Thread.sleep(100L);
            inProgress = false;
            for (DoAddClasses runnable : runnables) {
                inProgress = inProgress || runnable.isFailure() == null;
            }
        } while (inProgress);
        for (DoAddClasses runnable : runnables) {
            Assert.assertNotNull((String)("Threads not run # " + runnable.getWorkNumber()), (Object)runnable.isFailure());
            Assert.assertFalse((String)("thread failed #" + runnable.getWorkNumber() + " Failure: " + runnable.getFailureInfo()), (boolean)runnable.isFailure());
        }
        poolExecutor.awaitTermination(1L, TimeUnit.MINUTES);
        boolean bl = false;
        while (var9_16 < 100) {
            Query luceneQuery = parser.parse("Emmanuel" + (int)var9_16);
            Class<?> classByNumber = MutableFactoryTest.getClassAByNumber((int)var9_16);
            IndexReader indexReader = sf.getIndexReaderAccessor().open(new Class[]{classByNumber});
            IndexSearcher searcher = new IndexSearcher(indexReader);
            TopDocs hits = searcher.search(luceneQuery, 1000);
            Assert.assertEquals((long)1L, (long)hits.totalHits);
            searcher.close();
            sf.getIndexReaderAccessor().close(indexReader);
            ++var9_16;
        }
    }

    private static Class<?> getClassAByNumber(int i) throws ClassNotFoundException {
        Class aClass = ClassLoaderHelper.classForName((String)Generated.A0.class.getName().replace("A0", "A" + i));
        return aClass;
    }

    private static ManualConfiguration getTestConfiguration() {
        return new HibernateManualConfiguration().addProperty("hibernate.search.default.directory_provider", "ram").addProperty("hibernate.search.lucene_version", TestConstants.getTargetLuceneVersion().name());
    }

    private static class DoAddClasses
    implements Runnable {
        private final SearchFactoryIntegrator factory;
        private final int factorOfClassesPerThread;
        private final QueryParser parser;
        private final int nbrOfClassesPerThread;
        private volatile Boolean failure = false;
        private volatile String failureInfo;

        public String getFailureInfo() {
            return this.failureInfo;
        }

        public Boolean isFailure() {
            return this.failure;
        }

        public int getWorkNumber() {
            return this.factorOfClassesPerThread;
        }

        public DoAddClasses(SearchFactoryIntegrator factory, int factorOfClassesPerThread, int nbrOfClassesPerThread) {
            this.factory = factory;
            this.factorOfClassesPerThread = factorOfClassesPerThread;
            this.parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "name", TestConstants.standardAnalyzer);
            this.nbrOfClassesPerThread = nbrOfClassesPerThread;
        }

        @Override
        public void run() {
            try {
                for (int index = 0; index < 10; ++index) {
                    int i = this.factorOfClassesPerThread * this.nbrOfClassesPerThread + index;
                    Class aClass = MutableFactoryTest.getClassAByNumber(i);
                    this.factory.addClasses(new Class[]{aClass});
                    Object entity = aClass.getConstructor(Integer.class, String.class).newInstance(i, "Emmanuel" + i);
                    ManualTransactionContext context = new ManualTransactionContext();
                    MutableFactoryTest.doIndexWork(entity, i, this.factory, context);
                    context.end();
                    EntityIndexBinder indexBindingForEntity = this.factory.getIndexBindingForEntity(aClass);
                    Assert.assertNotNull((Object)indexBindingForEntity);
                    IndexManager[] indexManagers = indexBindingForEntity.getIndexManagers();
                    Assert.assertEquals((long)1L, (long)indexManagers.length);
                    DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexManagers[0];
                    DirectoryProvider directoryProvider = indexManager.getDirectoryProvider();
                    if (!(directoryProvider instanceof RAMDirectoryProvider)) {
                        throw new SearchException("Configuration lost: expected RAM directory");
                    }
                    Query luceneQuery = this.parser.parse("Emmanuel" + i);
                    IndexReader indexReader = this.factory.getIndexReaderAccessor().open(new Class[]{aClass});
                    IndexSearcher searcher = new IndexSearcher(indexReader);
                    TopDocs hits = searcher.search(luceneQuery, 1000);
                    if (hits.totalHits != 1) {
                        this.failure = true;
                        this.failureInfo = "failure: Emmanuel" + i + " for " + aClass.getName();
                        return;
                    }
                    searcher.close();
                    this.factory.getIndexReaderAccessor().close(indexReader);
                }
            }
            catch (Exception e) {
                this.failure = true;
                e.printStackTrace();
                this.failureInfo = "failure: Emmanuel" + this.factorOfClassesPerThread + " exception: " + e.toString();
            }
        }
    }
}

