/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.hibernate.search.SearchException;

public class ExcludeAllFilter
extends Filter
implements Serializable {
    private static final Map<IndexReader, IndexReader> invokedOnReaders = new ConcurrentHashMap<IndexReader, IndexReader>();

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        ExcludeAllFilter.verifyItsAReadOnlySegmentReader(reader);
        if (invokedOnReaders.containsKey(reader)) {
            throw new IllegalStateException("Called twice");
        }
        invokedOnReaders.put(reader, reader);
        return DocIdSet.EMPTY_DOCIDSET;
    }

    public static void verifyItsAReadOnlySegmentReader(IndexReader reader) {
        String implementationName = reader.getClass().getName();
        if (!"org.apache.lucene.index.ReadOnlySegmentReader".equals(implementationName)) {
            throw new SearchException("test failed: we should receive subreaders");
        }
    }
}

