/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import java.util.Calendar;
import java.util.List;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;

public class LuceneQuerySortTest
extends SearchTestCase {
    public void testList() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.createTestBooks(s);
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "title", TestConstants.stopAnalyzer);
        Query query = parser.parse("summary:lucene");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Book.class});
        List result = hibQuery.list();
        LuceneQuerySortTest.assertNotNull((Object)result);
        LuceneQuerySortTest.assertEquals((String)"Wrong number of test results.", (int)3, (int)result.size());
        int id = 1;
        for (Book b : result) {
            LuceneQuerySortTest.assertEquals((String)"Expected another id", (Object)id, (Object)b.getId());
            ++id;
        }
        query = parser.parse("summary:lucene");
        hibQuery = s.createFullTextQuery(query, new Class[]{Book.class});
        Sort sort = new Sort(new SortField("id", 3, true));
        hibQuery.setSort(sort);
        result = hibQuery.list();
        LuceneQuerySortTest.assertNotNull((Object)result);
        LuceneQuerySortTest.assertEquals((String)"Wrong number of test results.", (int)3, (int)result.size());
        id = 3;
        for (Book b : result) {
            LuceneQuerySortTest.assertEquals((String)"Expected another id", (Object)id, (Object)b.getId());
            --id;
        }
        query = parser.parse("summary:lucene OR summary:action");
        hibQuery = s.createFullTextQuery(query, new Class[]{Book.class});
        sort = new Sort(new SortField("summary_forSort", 3));
        hibQuery.setSort(sort);
        result = hibQuery.list();
        LuceneQuerySortTest.assertNotNull((Object)result);
        LuceneQuerySortTest.assertEquals((String)"Wrong number of test results.", (int)4, (int)result.size());
        LuceneQuerySortTest.assertEquals((String)"Groovy in Action", (String)((Book)result.get(0)).getSummary());
        query = parser.parse("summary:lucene OR summary:action");
        hibQuery = s.createFullTextQuery(query, new Class[]{Book.class});
        sort = new Sort(new SortField("summary_forSort", 3, true));
        hibQuery.setSort(sort);
        result = hibQuery.list();
        LuceneQuerySortTest.assertNotNull((Object)result);
        LuceneQuerySortTest.assertEquals((String)"Wrong number of test results.", (int)4, (int)result.size());
        LuceneQuerySortTest.assertEquals((String)"Hibernate & Lucene", (String)((Book)result.get(0)).getSummary());
        query = parser.parse("summary:lucene OR summary:action");
        hibQuery = s.createFullTextQuery(query, new Class[]{Book.class});
        sort = new Sort(new SortField("publicationDate", 3, true));
        hibQuery.setSort(sort);
        result = hibQuery.list();
        LuceneQuerySortTest.assertNotNull((Object)result);
        LuceneQuerySortTest.assertEquals((String)"Wrong number of test results.", (int)4, (int)result.size());
        for (Book book : result) {
            System.out.println(book.getSummary() + " : " + book.getPublicationDate());
        }
        LuceneQuerySortTest.assertEquals((String)"Groovy in Action", (String)((Book)result.get(0)).getSummary());
        tx.commit();
        this.deleteTestBooks(s);
        s.close();
    }

    private void createTestBooks(FullTextSession s) {
        Transaction tx = s.beginTransaction();
        Calendar cal = Calendar.getInstance();
        cal.set(2007, 7, 25, 11, 20, 30);
        Book book = new Book(1, "Hibernate & Lucene", "This is a test book.");
        book.setPublicationDate(cal.getTime());
        s.save((Object)book);
        cal.add(13, 1);
        book = new Book(2, "Hibernate & Lucene", "This is a test book.");
        book.setPublicationDate(cal.getTime());
        s.save((Object)book);
        cal.add(13, 1);
        book = new Book(3, "Hibernate & Lucene", "This is a test book.");
        book.setPublicationDate(cal.getTime());
        s.save((Object)book);
        cal.add(13, 1);
        book = new Book(4, "Groovy in Action", "The bible of Groovy");
        book.setPublicationDate(cal.getTime());
        s.save((Object)book);
        tx.commit();
        s.clear();
    }

    private void deleteTestBooks(FullTextSession s) {
        Transaction tx = s.beginTransaction();
        s.createQuery("delete " + Book.class.getName()).executeUpdate();
        tx.commit();
        s.clear();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, Author.class};
    }
}

