/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.similarity;

import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.similarity.Can;
import org.hibernate.search.test.similarity.DummySimilarity;
import org.hibernate.search.test.similarity.DummySimilarity2;
import org.hibernate.search.test.similarity.Trash;

public class SimilarityTest
extends SearchTestCase {
    public void testIndexLevelSimilarity() throws Exception {
        Configuration config = new Configuration();
        config.addAnnotatedClass(Can.class);
        config.addAnnotatedClass(Trash.class);
        config.setProperty("hibernate.search.default.directory_provider", "ram");
        config.setProperty("hibernate.search.default.similarity", DummySimilarity.class.getName());
        try {
            config.buildSessionFactory();
            SimilarityTest.fail((String)"Session creation should have failed due to duplicate similarity definition");
        }
        catch (SearchException e) {
            SimilarityTest.assertTrue((boolean)e.getMessage().startsWith("Multiple similarities defined"));
        }
    }

    public void testClassAndGlobalSimilarity() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Trash trash = new Trash();
        trash.setName("Green trash");
        s.persist((Object)trash);
        trash = new Trash();
        trash.setName("Green Green Green trash");
        s.persist((Object)trash);
        Can can = new Can();
        can.setName("Green can");
        s.persist((Object)can);
        can = new Can();
        can.setName("Green Green Green can");
        s.persist((Object)can);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        TermQuery tq = new TermQuery(new Term("name", "green"));
        FullTextSession fts = Search.getFullTextSession((Session)s);
        List results = fts.createFullTextQuery((Query)tq, new Class[]{Trash.class}).setProjection(new String[]{"__HSearch_Score", "__HSearch_This"}).list();
        SimilarityTest.assertEquals((int)2, (int)results.size());
        SimilarityTest.assertEquals((String)"Similarity not overridden at the class level", (Object)((Object[])results.get(0))[0], (Object)((Object[])results.get(1))[0]);
        SimilarityTest.assertEquals((String)"Similarity not overridden", (Object)Float.valueOf(1.0f), (Object)((Object[])results.get(0))[0]);
        for (Object result : results) {
            s.delete(((Object[])result)[1]);
        }
        results = fts.createFullTextQuery((Query)tq, new Class[]{Can.class}).setProjection(new String[]{"__HSearch_Score", "__HSearch_This"}).list();
        SimilarityTest.assertEquals((int)2, (int)results.size());
        SimilarityTest.assertEquals((String)"Similarity not overridden by the global setting", (Object)((Object[])results.get(0))[0], (Object)((Object[])results.get(1))[0]);
        SimilarityTest.assertFalse((String)"Similarity not overridden by the global setting", (boolean)new Float(1.0f).equals(((Object[])results.get(0))[0]));
        for (Object result : results) {
            s.delete(((Object[])result)[1]);
        }
        tx.commit();
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Trash.class, Can.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        cfg.setProperty("hibernate.search.similarity", DummySimilarity2.class.getName());
        super.configure(cfg);
    }
}

