/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.queryParser.QueryParser;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.directoryProvider.MultipleSFTestCase;
import org.hibernate.search.test.directoryProvider.SnowStorm;
import org.hibernate.search.util.impl.FileHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class FSSlaveAndMasterDPTest
extends MultipleSFTestCase {
    private static final Log log = LoggerFactory.make();
    static final String masterCopy = "/master/copy";
    static final String masterMain = "/master/main";
    static final String slave = "/slave";
    static final String slaveUnready = "/slaveUnready";
    private File root;

    public void testProperCopy() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.getSlaveSession());
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(FSSlaveAndMasterDPTest.getTargetLuceneVersion(), "id", TestConstants.stopAnalyzer);
        List result = fullTextSession.createFullTextQuery(parser.parse("location:texas"), new Class[0]).list();
        FSSlaveAndMasterDPTest.assertEquals((String)"No copy yet, fresh index expected", (int)0, (int)result.size());
        tx.commit();
        fullTextSession.close();
        Session session = this.getMasterSession();
        tx = session.beginTransaction();
        SnowStorm sn = new SnowStorm();
        sn.setDate(new Date());
        sn.setLocation("Dallas, TX, USA");
        session.persist((Object)sn);
        tx.commit();
        session.close();
        int waitPeriodMilli = 2010;
        Thread.sleep(waitPeriodMilli);
        log.debug((Object)"Searching master");
        fullTextSession = Search.getFullTextSession((Session)this.getMasterSession());
        tx = fullTextSession.beginTransaction();
        result = fullTextSession.createFullTextQuery(parser.parse("location:dallas"), new Class[0]).list();
        FSSlaveAndMasterDPTest.assertEquals((String)"Original should get one", (int)1, (int)result.size());
        tx.commit();
        fullTextSession.close();
        log.debug((Object)"Searching slave");
        fullTextSession = Search.getFullTextSession((Session)this.getSlaveSession());
        tx = fullTextSession.beginTransaction();
        result = fullTextSession.createFullTextQuery(parser.parse("location:dallas"), new Class[0]).list();
        FSSlaveAndMasterDPTest.assertEquals((String)"First copy did not work out", (int)1, (int)result.size());
        tx.commit();
        fullTextSession.close();
        session = this.getMasterSession();
        tx = session.beginTransaction();
        sn = new SnowStorm();
        sn.setDate(new Date());
        sn.setLocation("Chennai, India");
        session.persist((Object)sn);
        tx.commit();
        session.close();
        Thread.sleep(waitPeriodMilli);
        log.debug((Object)"Searching slave");
        fullTextSession = Search.getFullTextSession((Session)this.getSlaveSession());
        tx = fullTextSession.beginTransaction();
        result = fullTextSession.createFullTextQuery(parser.parse("location:chennai"), new Class[0]).list();
        FSSlaveAndMasterDPTest.assertEquals((String)"Second copy did not work out", (int)1, (int)result.size());
        tx.commit();
        fullTextSession.close();
        session = this.getMasterSession();
        tx = session.beginTransaction();
        sn = new SnowStorm();
        sn.setDate(new Date());
        sn.setLocation("Melbourne, Australia");
        session.persist((Object)sn);
        tx.commit();
        session.close();
        Thread.sleep(waitPeriodMilli);
        log.debug((Object)"Searching slave");
        fullTextSession = Search.getFullTextSession((Session)this.getSlaveSession());
        tx = fullTextSession.beginTransaction();
        result = fullTextSession.createFullTextQuery(parser.parse("location:melbourne"), new Class[0]).list();
        FSSlaveAndMasterDPTest.assertEquals((String)"Third copy did not work out", (int)1, (int)result.size());
        tx.commit();
        fullTextSession.close();
    }

    private Session getMasterSession() {
        return FSSlaveAndMasterDPTest.getSessionFactories()[0].openSession();
    }

    private Session getSlaveSession() {
        return FSSlaveAndMasterDPTest.getSessionFactories()[1].openSession();
    }

    static File prepareDirectories(String testId) {
        String superRootPath = TestConstants.getIndexDirectory();
        File root = new File(superRootPath, testId);
        if (root.exists()) {
            FileHelper.delete((File)root);
        }
        if (!root.mkdirs()) {
            throw new HibernateException("Unable to setup test directories");
        }
        File master = new File(root, masterMain);
        if (!master.mkdirs()) {
            throw new HibernateException("Unable to setup master directory");
        }
        master = new File(root, masterCopy);
        if (!master.mkdirs()) {
            throw new HibernateException("Unable to setup master copy directory");
        }
        File slaveFile = new File(root, slave);
        if (!slaveFile.mkdirs()) {
            throw new HibernateException("Unable to setup slave directory");
        }
        File slaveUnreadyFile = new File(root, slaveUnready);
        if (!slaveUnreadyFile.mkdirs()) {
            throw new HibernateException("Unable to setup slave directory");
        }
        return root;
    }

    @Override
    protected void setUp() throws Exception {
        this.root = FSSlaveAndMasterDPTest.prepareDirectories(((Object)((Object)this)).getClass().getSimpleName() + "." + this.getName());
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        FSSlaveAndMasterDPTest.cleanupDirectories(this.root);
    }

    static void cleanupDirectories(File root) {
        log.debugf("Deleting test directory %s ", (Object)root.getAbsolutePath());
        FileHelper.delete((File)root);
    }

    @Override
    protected int getSFNbrs() {
        return 2;
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{SnowStorm.class};
    }

    public void testSourceNotReady() throws Exception {
        int retries = 1;
        Configuration cfg = new Configuration();
        cfg.setProperty("hibernate.search.default.sourceBase", this.root.getAbsolutePath() + masterCopy + "nooooot");
        cfg.setProperty("hibernate.search.default.indexBase", this.root.getAbsolutePath() + slave);
        cfg.setProperty("hibernate.search.default.refresh", "1");
        cfg.setProperty("hibernate.search.lucene_version", "LUCENE_CURRENT");
        cfg.setProperty("hibernate.search.default.directory_provider", "filesystem-slave");
        cfg.setProperty("hibernate.search.default.retry_marker_lookup", String.valueOf(retries));
        cfg.addAnnotatedClass(SnowStorm.class);
        long start = System.nanoTime();
        try {
            cfg.buildSessionFactory();
        }
        catch (SearchException e) {
            long elapsedTime = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start);
            FSSlaveAndMasterDPTest.assertTrue((String)("Should be around 10 seconds: " + elapsedTime), (elapsedTime > (long)(retries * 5 - 1) ? 1 : 0) != 0);
        }
    }

    @Override
    protected void configure(Configuration[] cfg) {
        cfg[0].setProperty("hibernate.search.default.sourceBase", this.root.getAbsolutePath() + masterCopy);
        cfg[0].setProperty("hibernate.search.default.indexBase", this.root.getAbsolutePath() + masterMain);
        cfg[0].setProperty("hibernate.search.default.refresh", "1");
        cfg[0].setProperty("hibernate.search.lucene_version", "LUCENE_CURRENT");
        cfg[0].setProperty("hibernate.search.default.directory_provider", "filesystem-master");
        cfg[1].setProperty("hibernate.search.default.sourceBase", this.root.getAbsolutePath() + masterCopy);
        cfg[1].setProperty("hibernate.search.default.indexBase", this.root.getAbsolutePath() + slave);
        cfg[1].setProperty("hibernate.search.default.refresh", "1");
        cfg[1].setProperty("hibernate.search.lucene_version", "LUCENE_CURRENT");
        cfg[1].setProperty("hibernate.search.default.directory_provider", "filesystem-slave");
    }
}

