/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.nested;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.test.embedded.nested.Place;

@Entity
public class Address {
    @Id
    @GeneratedValue
    private Long id;
    @Field
    private String street;
    @Field
    private String city;
    @ContainedIn
    @OneToMany(mappedBy="address")
    private Set<Place> places = new HashSet<Place>();

    public Address(String street, String city) {
        this();
        this.street = street;
        this.city = city;
    }

    private Address() {
    }

    public Long getId() {
        return this.id;
    }

    public String getStreet() {
        return this.street;
    }

    public String getCity() {
        return this.city;
    }

    public Set<Place> getPlaces() {
        return this.places;
    }

    public void addPlace(Place place) {
        this.places.add(place);
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public void setCity(String city) {
        this.city = city;
    }
}

