/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.polymorphism;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.embedded.polymorphism.DerivedLevel2;
import org.hibernate.search.test.embedded.polymorphism.Level1;
import org.hibernate.search.test.embedded.polymorphism.Level2;
import org.hibernate.search.test.embedded.polymorphism.Level3;
import org.hibernate.search.test.util.TestForIssue;

@TestForIssue(jiraKey="HSEARCH-1241")
public class PolymorphicAssociationTest
extends SearchTestCase {
    private static final String INIT_NAME = "initname";
    private static final String EDIT_NAME = "editname";

    public void testPolymorphicAssociation() {
        this.prepareEntities(INIT_NAME);
        this.changeLevel3Name(INIT_NAME, EDIT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareEntities(String level3Name) {
        Session session = this.openSession();
        try {
            Transaction transaction = session.beginTransaction();
            Level1 level1 = new Level1();
            DerivedLevel2 level2 = new DerivedLevel2();
            Level3 level3 = new Level3();
            level1.setLevel2Child(level2);
            level2.setLevel1Parent(level1);
            level2.setLevel3Child(level3);
            level3.setLevel2Parent(level2);
            level3.setName(level3Name);
            session.save((Object)level1);
            session.save((Object)level2);
            session.save((Object)level3);
            transaction.commit();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeLevel3Name(String currentName, String newName) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        try {
            Transaction transaction = fullTextSession.beginTransaction();
            TermQuery q = new TermQuery(new Term("name", currentName));
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)q, new Class[0]);
            PolymorphicAssociationTest.assertEquals((int)1, (int)fullTextQuery.getResultSize());
            Level3 level3 = (Level3)fullTextQuery.list().get(0);
            level3.setName(newName);
            transaction.commit();
        }
        finally {
            fullTextSession.close();
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Level1.class, Level2.class, DerivedLevel2.class, Level3.class};
    }
}

