/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.slave;

import java.io.Serializable;
import java.util.UUID;
import junit.framework.Assert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.jgroups.slave.JGroupsReceiver;
import org.hibernate.search.test.jgroups.slave.TShirt;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Receiver;

public class JGroupsSlaveTest
extends SearchTestCase {
    private Channel channel;
    private final String CHANNEL_NAME = UUID.randomUUID().toString();

    public void testMessageSend() throws Exception {
        int i;
        JGroupsReceiver.reset();
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        TShirt ts = new TShirt();
        ts.setLogo("Boston");
        ts.setSize("XXL");
        ts.setLength(23.3);
        TShirt ts2 = new TShirt();
        ts2.setLogo("Mapple leaves");
        ts2.setSize("L");
        ts2.setLength(23.32);
        s.persist((Object)ts);
        s.persist((Object)ts2);
        tx.commit();
        Thread.sleep(100L);
        boolean failed = true;
        for (i = 0; i < 100; ++i) {
            Thread.sleep(100L);
            if (JGroupsReceiver.queues != 1 || JGroupsReceiver.works != 2) continue;
            failed = false;
            break;
        }
        if (failed) {
            Assert.fail((String)"Message not received after waiting for long!");
        }
        JGroupsReceiver.reset();
        s = this.openSession();
        tx = s.beginTransaction();
        ts = (TShirt)s.get(TShirt.class, (Serializable)Integer.valueOf(ts.getId()));
        ts.setLogo("Peter pan");
        tx.commit();
        failed = true;
        for (i = 0; i < 100; ++i) {
            Thread.sleep(100L);
            if (JGroupsReceiver.queues != 1 || JGroupsReceiver.works != 1) continue;
            failed = false;
            break;
        }
        if (failed) {
            Assert.fail((String)"Message not received after waiting for long!");
        }
        JGroupsReceiver.reset();
        s = this.openSession();
        tx = s.beginTransaction();
        s.delete(s.get(TShirt.class, (Serializable)Integer.valueOf(ts.getId())));
        tx.commit();
        failed = true;
        for (i = 0; i < 100; ++i) {
            Thread.sleep(100L);
            if (JGroupsReceiver.queues != 1 || JGroupsReceiver.works != 1) continue;
            failed = false;
            break;
        }
        if (failed) {
            Assert.fail((String)"Message not received after waiting for long!");
        }
        s.close();
    }

    private void prepareJGroupsChannel() throws Exception {
        this.channel = new JChannel(ConfigurationParseHelper.locateConfig((String)"testing-flush-loopback.xml"));
        this.channel.connect(this.CHANNEL_NAME);
        this.channel.setReceiver((Receiver)new JGroupsReceiver(this.getSearchFactoryImpl()));
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.prepareJGroupsChannel();
    }

    @Override
    public void tearDown() throws Exception {
        this.channel.close();
        super.tearDown();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{TShirt.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.worker.backend", "jgroupsSlave");
        cfg.setProperty("hibernate.search.services.jgroups.clusterName", this.CHANNEL_NAME);
        cfg.setProperty("hibernate.search.services.jgroups.configurationFile", "testing-flush-loopback.xml");
    }
}

