/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jms.master;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.activemq.broker.BrokerService;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.jdbc.Work;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.jms.master.MDBSearchController;
import org.hibernate.search.test.jms.master.TShirt;

public class JMSMasterTest
extends SearchTestCase {
    private static final String QUEUE_NAME = "queue/searchtest";
    private static final String CONNECTION_FACTORY_NAME = "java:/ConnectionFactory";
    private BrokerService brokerService;
    private QueueSession queueSession;

    public void testMessageSending() throws Exception {
        TShirt shirt = this.createObjectWithSQL();
        List<LuceneWork> queue = this.createDocumentAndWorkQueue(shirt);
        this.registerMessageListener();
        this.sendMessage(queue);
        Thread.sleep(1000L);
        FullTextSession ftSess = Search.getFullTextSession((Session)this.openSession());
        ftSess.getTransaction().begin();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.stopAnalyzer);
        Query luceneQuery = parser.parse("logo:jboss");
        FullTextQuery query = ftSess.createFullTextQuery(luceneQuery, new Class[0]);
        List result = query.list();
        JMSMasterTest.assertEquals((int)1, (int)result.size());
        ftSess.delete(result.get(0));
        ftSess.getTransaction().commit();
        ftSess.close();
    }

    private void registerMessageListener() throws Exception {
        MessageConsumer consumer = this.getQueueSession().createConsumer((Destination)this.getMessageQueue());
        consumer.setMessageListener((MessageListener)new MDBSearchController(this.getSessions()));
    }

    private void sendMessage(List<LuceneWork> queue) throws Exception {
        ObjectMessage message = this.getQueueSession().createObjectMessage();
        String indexName = TShirt.class.getName();
        message.setStringProperty("HSearchIndexName", indexName);
        IndexManager indexManager = this.getSearchFactoryImpl().getAllIndexesManager().getIndexManager(indexName);
        byte[] data = indexManager.getSerializer().toSerializedModel(queue);
        message.setObject((Serializable)data);
        QueueSender sender = this.getQueueSession().createSender(this.getMessageQueue());
        sender.send((Message)message);
    }

    private Queue getMessageQueue() throws Exception {
        Context ctx = this.getJndiInitialContext();
        return (Queue)ctx.lookup(QUEUE_NAME);
    }

    private QueueSession getQueueSession() throws Exception {
        if (this.queueSession == null) {
            Context ctx = this.getJndiInitialContext();
            QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup(CONNECTION_FACTORY_NAME);
            QueueConnection conn = factory.createQueueConnection();
            conn.start();
            this.queueSession = conn.createQueueSession(false, 1);
        }
        return this.queueSession;
    }

    private Context getJndiInitialContext() throws NamingException {
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        props.setProperty("java.naming.provider.url", "vm://localhost");
        props.setProperty("connectionFactoryNames", "ConnectionFactory, java:/ConnectionFactory");
        props.setProperty("queue.queue/searchtest", "searchQueue");
        return new InitialContext(props);
    }

    private List<LuceneWork> createDocumentAndWorkQueue(TShirt shirt) {
        Document doc = new Document();
        Field field = new Field("_hibernate_class", shirt.getClass().getName(), Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add((Fieldable)field);
        field = new Field("id", "1", Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add((Fieldable)field);
        field = new Field("logo", shirt.getLogo(), Field.Store.NO, Field.Index.ANALYZED);
        doc.add((Fieldable)field);
        NumericField numField = new NumericField("length");
        numField.setDoubleValue(shirt.getLength());
        doc.add((Fieldable)numField);
        AddLuceneWork luceneWork = new AddLuceneWork((Serializable)Integer.valueOf(shirt.getId()), String.valueOf(shirt.getId()), shirt.getClass(), doc);
        ArrayList<LuceneWork> queue = new ArrayList<LuceneWork>();
        queue.add((LuceneWork)luceneWork);
        return queue;
    }

    private TShirt createObjectWithSQL() throws SQLException {
        Session s = this.openSession();
        s.getTransaction().begin();
        s.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                Statement statement = connection.createStatement();
                statement.executeUpdate("insert into TShirt_Master(id, logo, size_, length_) values( 1, 'JBoss balls', 'large', 23.2)");
                statement.close();
            }
        });
        TShirt ts = (TShirt)s.get(TShirt.class, (Serializable)Integer.valueOf(1));
        s.getTransaction().commit();
        s.close();
        return ts;
    }

    @Override
    public void setUp() throws Exception {
        this.brokerService = JMSMasterTest.createTestingBrokerService();
        super.setUp();
    }

    public static BrokerService createTestingBrokerService() throws Exception {
        BrokerService brokerService = new BrokerService();
        brokerService.setPersistent(false);
        brokerService.setUseJmx(false);
        brokerService.setUseShutdownHook(false);
        brokerService.setEnableStatistics(false);
        brokerService.start();
        return brokerService;
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.worker.backend", "lucene");
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{TShirt.class};
    }
}

