/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.service.internal.EventListenerRegistryImpl;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEvent;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEvent;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.search.event.impl.FullTextIndexEventListener;
import org.hibernate.search.hcore.impl.HibernateSearchIntegrator;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.junit.Assert;
import org.junit.Test;

public class HibernateSearchIntegratorTest {
    @Test
    public void testRegisterOnEmptyListeners_CfgDisabled() {
        Configuration cfg = HibernateSearchIntegratorTest.makeConfiguration(false);
        HibernateSearchIntegrator integrator = new HibernateSearchIntegrator();
        SimpleSessionFactoryServiceRegistry serviceRegistry = new SimpleSessionFactoryServiceRegistry();
        integrator.integrate(cfg, null, (SessionFactoryServiceRegistry)serviceRegistry);
        this.assertPresence(false, (ServiceRegistry)serviceRegistry);
        integrator.disintegrate(null, (SessionFactoryServiceRegistry)serviceRegistry);
    }

    @Test
    public void testRegisterOnEmptyListeners_CfgEnabled() {
        Configuration cfg = HibernateSearchIntegratorTest.makeConfiguration(true);
        HibernateSearchIntegrator integrator = new HibernateSearchIntegrator();
        SimpleSessionFactoryServiceRegistry serviceRegistry = new SimpleSessionFactoryServiceRegistry();
        integrator.integrate(cfg, null, (SessionFactoryServiceRegistry)serviceRegistry);
        this.assertPresence(true, (ServiceRegistry)serviceRegistry);
        integrator.disintegrate(null, (SessionFactoryServiceRegistry)serviceRegistry);
    }

    @Test
    public void testRegisterOnEmptyListeners_CfgAuto() {
        Configuration cfg = HibernateSearchIntegratorTest.makeConfiguration(null);
        HibernateSearchIntegrator integrator = new HibernateSearchIntegrator();
        SimpleSessionFactoryServiceRegistry serviceRegistry = new SimpleSessionFactoryServiceRegistry();
        integrator.integrate(cfg, null, (SessionFactoryServiceRegistry)serviceRegistry);
        this.assertPresence(true, (ServiceRegistry)serviceRegistry);
        integrator.disintegrate(null, (SessionFactoryServiceRegistry)serviceRegistry);
    }

    @Test
    public void testOnAlreadyRegistered() {
        this.helperOnAlreadyRegistered(new FullTextIndexEventListener(FullTextIndexEventListener.Installation.SINGLE_INSTANCE));
    }

    @Test
    public void testOnPopulatedEventListeners() {
        Configuration cfg = HibernateSearchIntegratorTest.makeConfiguration(null);
        HibernateSearchIntegrator integrator = new HibernateSearchIntegrator();
        SimpleSessionFactoryServiceRegistry serviceRegistry = new SimpleSessionFactoryServiceRegistry();
        this.makeSomeEventListeners((ServiceRegistry)serviceRegistry);
        integrator.integrate(cfg, null, (SessionFactoryServiceRegistry)serviceRegistry);
        this.assertPresence(true, (ServiceRegistry)serviceRegistry);
        integrator.disintegrate(null, (SessionFactoryServiceRegistry)serviceRegistry);
    }

    private void helperOnAlreadyRegistered(FullTextIndexEventListener listenerFullText) {
        SimpleSessionFactoryServiceRegistry serviceRegistry = new SimpleSessionFactoryServiceRegistry();
        AnotherListenerA listenerA = new AnotherListenerA();
        AnotherListenerB listenerB = new AnotherListenerB();
        EventListenerRegistry service = serviceRegistry.getService(EventListenerRegistry.class);
        service.getEventListenerGroup(EventType.POST_INSERT).appendListeners((Object[])new PostInsertEventListener[]{listenerA, listenerB, listenerFullText});
        service.getEventListenerGroup(EventType.POST_UPDATE).appendListeners((Object[])new PostUpdateEventListener[]{listenerA, listenerB, listenerFullText});
        service.getEventListenerGroup(EventType.POST_DELETE).appendListeners((Object[])new PostDeleteEventListener[]{listenerA, listenerB, listenerFullText});
        service.getEventListenerGroup(EventType.POST_COLLECTION_RECREATE).appendListeners((Object[])new PostCollectionRecreateEventListener[]{listenerA, listenerB, listenerFullText});
        service.getEventListenerGroup(EventType.POST_COLLECTION_REMOVE).appendListeners((Object[])new PostCollectionRemoveEventListener[]{listenerA, listenerB, listenerFullText});
        service.getEventListenerGroup(EventType.POST_COLLECTION_UPDATE).appendListeners((Object[])new PostCollectionUpdateEventListener[]{listenerA, listenerB, listenerFullText});
        HibernateSearchIntegrator integrator = new HibernateSearchIntegrator();
        integrator.integrate(HibernateSearchIntegratorTest.makeConfiguration(false), null, (SessionFactoryServiceRegistry)serviceRegistry);
        this.assertPresence(true, (ServiceRegistry)serviceRegistry);
    }

    private void makeSomeEventListeners(ServiceRegistry serviceRegistry) {
        AnotherListenerA listenerA = new AnotherListenerA();
        AnotherListenerB listenerB = new AnotherListenerB();
        AnotherListenerC listenerC = new AnotherListenerC();
        EventListenerRegistry service = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        service.getEventListenerGroup(EventType.POST_INSERT).appendListeners((Object[])new PostInsertEventListener[]{listenerA, listenerB, listenerC});
        service.getEventListenerGroup(EventType.POST_UPDATE).appendListeners((Object[])new PostUpdateEventListener[]{listenerA, listenerB, listenerC});
        service.getEventListenerGroup(EventType.POST_DELETE).appendListeners((Object[])new PostDeleteEventListener[]{listenerA, listenerB, listenerC});
        service.getEventListenerGroup(EventType.POST_COLLECTION_RECREATE).appendListeners((Object[])new PostCollectionRecreateEventListener[]{listenerA, listenerB, listenerC});
        service.getEventListenerGroup(EventType.POST_COLLECTION_REMOVE).appendListeners((Object[])new PostCollectionRemoveEventListener[]{listenerA, listenerB, listenerC});
        service.getEventListenerGroup(EventType.POST_COLLECTION_UPDATE).appendListeners((Object[])new PostCollectionUpdateEventListener[]{listenerA, listenerB, listenerC});
    }

    private void assertPresence(boolean expected, ServiceRegistry serviceRegistry) {
        EventListenerRegistry service = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        Assert.assertEquals((Object)expected, (Object)HibernateSearchIntegratorTest.isPresent(service.getEventListenerGroup(EventType.POST_INSERT).listeners()));
        Assert.assertEquals((Object)expected, (Object)HibernateSearchIntegratorTest.isPresent(service.getEventListenerGroup(EventType.POST_UPDATE).listeners()));
        Assert.assertEquals((Object)expected, (Object)HibernateSearchIntegratorTest.isPresent(service.getEventListenerGroup(EventType.POST_DELETE).listeners()));
        Assert.assertEquals((Object)expected, (Object)HibernateSearchIntegratorTest.isPresent(service.getEventListenerGroup(EventType.POST_COLLECTION_RECREATE).listeners()));
        Assert.assertEquals((Object)expected, (Object)HibernateSearchIntegratorTest.isPresent(service.getEventListenerGroup(EventType.POST_COLLECTION_REMOVE).listeners()));
        Assert.assertEquals((Object)expected, (Object)HibernateSearchIntegratorTest.isPresent(service.getEventListenerGroup(EventType.POST_COLLECTION_UPDATE).listeners()));
    }

    private static Configuration makeConfiguration(Boolean enableSearch) {
        Configuration cfg = new Configuration();
        Properties p = new Properties();
        cfg.setProperties(p);
        if (enableSearch != null) {
            p.setProperty("hibernate.search.autoregister_listeners", String.valueOf(enableSearch));
        }
        return cfg;
    }

    private static boolean isPresent(Iterable<?> listeners) {
        if (listeners == null) {
            return false;
        }
        boolean found = false;
        for (Object eventListener : listeners) {
            if (FullTextIndexEventListener.class != eventListener.getClass()) continue;
            Assert.assertFalse((boolean)found);
            found = true;
        }
        return found;
    }

    private static class SimpleSessionFactoryServiceRegistry
    implements SessionFactoryServiceRegistry {
        private final EventListenerRegistryImpl eventListenerRegistry = new EventListenerRegistryImpl();

        private SimpleSessionFactoryServiceRegistry() {
        }

        public <R extends Service> ServiceBinding<R> locateServiceBinding(Class<R> serviceRole) {
            return null;
        }

        public void destroy() {
        }

        public ServiceRegistry getParentServiceRegistry() {
            return null;
        }

        public <R extends Service> R getService(Class<R> serviceRole) {
            if (EventListenerRegistry.class.equals(serviceRole)) {
                return (R)this.eventListenerRegistry;
            }
            return null;
        }
    }

    private static class AnotherListenerC
    extends AnotherListener {
        private AnotherListenerC() {
        }
    }

    private static class AnotherListenerB
    extends AnotherListener {
        private AnotherListenerB() {
        }
    }

    private static class AnotherListenerA
    extends AnotherListener {
        private AnotherListenerA() {
        }
    }

    private static class AnotherListener
    implements PostDeleteEventListener,
    PostInsertEventListener,
    PostUpdateEventListener,
    PostCollectionRecreateEventListener,
    PostCollectionRemoveEventListener,
    PostCollectionUpdateEventListener {
        private AnotherListener() {
        }

        public void onPostDelete(PostDeleteEvent event) {
        }

        public void onPostInsert(PostInsertEvent event) {
        }

        public void onPostUpdate(PostUpdateEvent event) {
        }

        public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        }

        public void onPostRemoveCollection(PostCollectionRemoveEvent event) {
        }

        public void onPostUpdateCollection(PostCollectionUpdateEvent event) {
        }
    }
}

