/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.nested;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.test.embedded.nested.Address;
import org.hibernate.search.test.embedded.nested.Person;

@Entity
public class Place {
    @Id
    @GeneratedValue
    private Long id;
    @Field
    private String name;
    @OneToOne(cascade={CascadeType.ALL})
    @IndexedEmbedded
    private Address address;
    @ContainedIn
    @ManyToMany(cascade={CascadeType.ALL}, mappedBy="placesVisited")
    private Set<Person> visitedBy = new HashSet<Person>();

    private Place() {
    }

    public Place(String name) {
        this();
        this.name = name;
    }

    public Address getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    public Long getId() {
        return this.id;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void visitedBy(Person person) {
        this.visitedBy.add(person);
    }

    public Set<Person> getVisitedBy() {
        return this.visitedBy;
    }
}

