/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.worker.duplication;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import org.hibernate.annotations.Cascade;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.test.worker.duplication.EmailAddress;
import org.hibernate.search.test.worker.duplication.Person;

@Entity
@Indexed
@DiscriminatorValue(value="SpecialPerson")
public class SpecialPerson
extends Person {
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="SPECIALPERSON_FK")
    @IndexedEmbedded
    private Set<EmailAddress> emailAddressSet = new HashSet<EmailAddress>();

    public Set<EmailAddress> getEmailAddressSet() {
        return this.emailAddressSet;
    }

    public void setEmailAddressSet(Set<EmailAddress> emailAddresses) {
        EmailAddress defaultVal = this.getDefaultEmailAddressFromList(emailAddresses);
        super.setDefaultEmailAddress(defaultVal);
        this.emailAddressSet = emailAddresses;
    }

    public void addEmailAddress(EmailAddress emailAddress) {
        if (emailAddress != null) {
            if (this.emailAddressSet == null) {
                this.emailAddressSet = new HashSet<EmailAddress>();
            }
            if (emailAddress.isDefaultAddress()) {
                this.processDefaultEmailAddress(emailAddress, this.emailAddressSet);
                super.setDefaultEmailAddress(emailAddress);
            } else {
                this.emailAddressSet.add(emailAddress);
            }
        }
    }

    private void processDefaultEmailAddress(EmailAddress defaultVal, Set<EmailAddress> list) {
        if (defaultVal != null) {
            boolean addToList = true;
            for (EmailAddress aList : list) {
                if (defaultVal.equals(aList)) {
                    aList.setDefaultAddress(true);
                    addToList = false;
                    continue;
                }
                if (!aList.isDefaultAddress()) continue;
                aList.setDefaultAddress(false);
            }
            if (addToList) {
                list.add(defaultVal);
            }
        }
    }

    private EmailAddress getDefaultEmailAddressFromList(Set<EmailAddress> list) {
        EmailAddress address = null;
        EmailAddress firstAddressInList = null;
        boolean found = false;
        if (list != null) {
            for (EmailAddress aList : list) {
                address = aList;
                if (address == null) continue;
                if (firstAddressInList == null) {
                    firstAddressInList = address;
                }
                if (!address.isDefaultAddress()) continue;
                found = true;
                break;
            }
            if (!found && firstAddressInList != null) {
                firstAddressInList.setDefaultAddress(true);
                address = firstAddressInList;
            }
        }
        return address;
    }
}

