/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer;

import java.lang.annotation.ElementType;
import org.apache.solr.analysis.GermanStemFilterFactory;
import org.apache.solr.analysis.LowerCaseFilterFactory;
import org.apache.solr.analysis.SnowballPorterFilterFactory;
import org.apache.solr.analysis.StandardTokenizerFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.SearchException;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.analyzer.BlogEntry;
import org.hibernate.search.test.analyzer.Entity1;
import org.hibernate.search.test.analyzer.Entity2;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DuplicatedAnalyzerDefinitionTest
extends SearchTestCase {
    public static final Log log = LoggerFactory.make();

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[0];
    }

    public void testDuplicatedAnalyzerDefinitionThrowsException() throws Exception {
        Configuration config = new Configuration();
        config.addAnnotatedClass(Entity1.class);
        config.addAnnotatedClass(Entity2.class);
        config.setProperty("hibernate.search.default.directory_provider", "ram");
        try {
            config.buildSessionFactory();
            DuplicatedAnalyzerDefinitionTest.fail((String)"Session creation should have failed due to duplicate analyzer definition");
        }
        catch (SearchException e) {
            DuplicatedAnalyzerDefinitionTest.assertTrue((boolean)e.getMessage().equals("Multiple analyzer definitions with the same name: my-analyzer"));
        }
    }

    public void testDuplicatedProgrammaticAnalyzerDefinitionThrowsException() throws Exception {
        Configuration config = new Configuration();
        config.getProperties().put("hibernate.search.model_mapping", this.createSearchMapping());
        config.setProperty("hibernate.search.default.directory_provider", "ram");
        try {
            config.buildSessionFactory();
            DuplicatedAnalyzerDefinitionTest.fail((String)"Session creation should have failed due to duplicate analyzer definition");
        }
        catch (SearchException e) {
            DuplicatedAnalyzerDefinitionTest.assertTrue((boolean)e.getMessage().equals("Multiple analyzer definitions with the same name: english"));
        }
    }

    private SearchMapping createSearchMapping() {
        SearchMapping mapping = new SearchMapping();
        mapping.analyzerDef("english", StandardTokenizerFactory.class).filter(LowerCaseFilterFactory.class).filter(SnowballPorterFilterFactory.class).analyzerDef("english", StandardTokenizerFactory.class).filter(LowerCaseFilterFactory.class).filter(GermanStemFilterFactory.class).entity(BlogEntry.class).indexed().property("title", ElementType.METHOD);
        return mapping;
    }
}

