/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.service;

import java.util.Properties;
import org.hibernate.search.engine.ServiceManager;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.impl.RAMDirectoryProvider;
import org.hibernate.search.test.service.MyService;
import org.hibernate.search.test.service.MyServiceProvider;

public class ServiceDirectoryProvider
extends RAMDirectoryProvider {
    private ServiceManager serviceManager;
    private MyService foo;

    public void initialize(String directoryProviderName, Properties properties, BuildContext context) {
        super.initialize(directoryProviderName, properties, context);
        this.serviceManager = context.getServiceManager();
        this.foo = (MyService)this.serviceManager.requestService(MyServiceProvider.class, context);
    }

    public void start(DirectoryBasedIndexManager indexManager) {
        if (this.foo == null) {
            throw new RuntimeException("service should be started");
        }
        super.start(indexManager);
    }

    public void stop() {
        super.stop();
        this.serviceManager.releaseService(MyServiceProvider.class);
    }
}

