/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.worker.duplication;

import java.io.IOException;
import java.io.Serializable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.hibernate.Session;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.session.Domain;

public class WorkSequencesTest
extends SearchTestCase {
    private SearchFactory searchFactory;

    public void testComplexTransactionSequence() throws IOException {
        Session classicSession = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)classicSession);
        this.searchFactory = session.getSearchFactory();
        session.beginTransaction();
        session.persist((Object)new Domain(1, "jboss.org"));
        session.persist((Object)new Domain(2, "jboss.com"));
        session.persist((Object)new Domain(3, "hibernate.org"));
        session.persist((Object)new Domain(4, "geocities.com"));
        session.getTransaction().commit();
        WorkSequencesTest.assertEquals((int)2, (int)this.countDomainsByFullText("jboss"));
        WorkSequencesTest.assertEquals((int)1, (int)this.countDomainsByFullText("hibernate"));
        WorkSequencesTest.assertEquals((int)1, (int)this.countDomainsByFullText("geocities"));
        session.beginTransaction();
        session.persist((Object)new Domain(5, "sun.com"));
        session.persist((Object)new Domain(6, "mysql.com"));
        session.persist((Object)new Domain(7, "oracle.com"));
        Domain hibernateDomain = (Domain)session.get(Domain.class, (Serializable)Integer.valueOf(3));
        session.delete((Object)hibernateDomain);
        Domain geocitiesDomain = (Domain)session.get(Domain.class, (Serializable)Integer.valueOf(4));
        session.delete((Object)geocitiesDomain);
        session.getTransaction().commit();
        WorkSequencesTest.assertEquals((int)0, (int)this.countDomainsByFullText("hibernate"));
        WorkSequencesTest.assertEquals((int)0, (int)this.countDomainsByFullText("geocities"));
        WorkSequencesTest.assertEquals((int)2, (int)this.countDomainsByFullText("jboss"));
        WorkSequencesTest.assertEquals((int)1, (int)this.countDomainsByFullText("sun"));
        WorkSequencesTest.assertEquals((int)1, (int)this.countDomainsByFullText("mysql"));
        WorkSequencesTest.assertEquals((int)1, (int)this.countDomainsByFullText("oracle"));
        session.beginTransaction();
        session.persist((Object)new Domain(3, "hibernate.org"));
        Domain mysqlDomain = (Domain)session.get(Domain.class, (Serializable)Integer.valueOf(6));
        session.delete((Object)mysqlDomain);
        session.persist((Object)new Domain(6, "myhql.org"));
        Domain sunDomain = (Domain)session.get(Domain.class, (Serializable)Integer.valueOf(5));
        sunDomain.setName("community.oracle.com");
        session.getTransaction().commit();
        WorkSequencesTest.assertEquals((int)1, (int)this.countDomainsByFullText("hibernate"));
        WorkSequencesTest.assertEquals((int)2, (int)this.countDomainsByFullText("oracle"));
        WorkSequencesTest.assertEquals((int)1, (int)this.countDomainsByFullText("myhql"));
        WorkSequencesTest.assertEquals((int)1, (int)this.countDomainsByFullText("community"));
        WorkSequencesTest.assertEquals((int)0, (int)this.countDomainsByFullText("mysql"));
        session.beginTransaction();
        session.persist((Object)new Domain(8, "mysql.org"));
        mysqlDomain = (Domain)session.load(Domain.class, (Serializable)Integer.valueOf(8));
        session.delete((Object)mysqlDomain);
        Domain newDomain = new Domain(8, "something.org");
        session.persist((Object)newDomain);
        session.delete((Object)newDomain);
        session.persist((Object)new Domain(8, "somethingnew.org"));
        session.getTransaction().commit();
        WorkSequencesTest.assertEquals((int)1, (int)this.countDomainsByFullText("somethingnew"));
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countDomainsByFullText(String name) throws IOException {
        TermQuery luceneQuery = new TermQuery(new Term("name", name));
        IndexReader indexReader = this.searchFactory.getIndexReaderAccessor().open(new Class[]{Domain.class});
        try {
            IndexSearcher searcher = new IndexSearcher(indexReader);
            TopDocs topDocs = searcher.search((Query)luceneQuery, null, 100);
            int n = topDocs.totalHits;
            return n;
        }
        finally {
            this.searchFactory.getIndexReaderAccessor().close(indexReader);
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Domain.class};
    }
}

