/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.test.bridge.Student;
import org.hibernate.search.test.bridge.StudentsSizeBridge;

@Entity
@Indexed
@Table(name="teacher")
@ClassBridge(name="amount_of_students", analyze=Analyze.NO, store=Store.YES, impl=StudentsSizeBridge.class)
public class Teacher {
    private Long id;
    private String name;
    private List<Student> students = new ArrayList<Student>();

    @Id
    @GeneratedValue
    @Column(name="teacher_id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="name")
    @Field(store=Store.YES)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @OneToMany(mappedBy="teacher")
    public List<Student> getStudents() {
        return this.students;
    }

    public void setStudents(List<Student> students) {
        this.students = students;
    }
}

