/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.event.autoindexembeddable;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.event.autoindexembeddable.Book;
import org.hibernate.search.test.jpa.JPATestCase;
import org.hibernate.search.test.util.TestForIssue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1358")
public class EventBasedEmbeddableCollectionUpdateTest
extends JPATestCase {
    private EntityManager entityManager;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.entityManager = this.factory.createEntityManager();
    }

    @Override
    @After
    public void tearDown() {
        FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.entityManager);
        fullTextEntityManager.purgeAll(Book.class);
        fullTextEntityManager.flushToIndexes();
        fullTextEntityManager.close();
        super.tearDown();
    }

    @Test
    public void testUpdateOfEmbeddedElementCollectionTriggersIndexUpdate() throws Exception {
        this.indexBookAndEnsureItIsIndexed();
        this.entityManager.getTransaction().begin();
        Book book = (Book)this.entityManager.find(Book.class, (Object)1234L);
        book.getEmbeddableCategories().getCategories().remove(12L);
        book.getEmbeddableCategories().getCategories().put(13L, "Bar");
        this.entityManager.persist((Object)book);
        this.entityManager.getTransaction().commit();
        Assert.assertEquals((String)"Foo should have been removed by indexed update", (long)0L, (long)this.search("embeddableCategories.categories:Foo").size());
        Assert.assertEquals((String)"Bar should have been added by indexed update", (long)1L, (long)this.search("embeddableCategories.categories:Bar").size());
    }

    @Override
    public Class[] getAnnotatedClasses() {
        return new Class[0];
    }

    private void indexBookAndEnsureItIsIndexed() throws ParseException {
        this.entityManager.getTransaction().begin();
        Book book = new Book();
        book.setId(1234L);
        book.getEmbeddableCategories().getCategories().put(12L, "Foo");
        this.entityManager.persist((Object)book);
        this.entityManager.getTransaction().commit();
        Assert.assertEquals((String)"Foo should have been added during indexing", (long)1L, (long)this.search("embeddableCategories.categories:Foo").size());
        Assert.assertEquals((String)"Bar was not yet added", (long)0L, (long)this.search("embeddableCategories.categories:Bar").size());
    }

    private List<Book> search(String searchQuery) throws ParseException {
        MultiFieldQueryParser parser = new MultiFieldQueryParser(TestConstants.getTargetLuceneVersion(), new String[0], (Analyzer)new StandardAnalyzer(TestConstants.getTargetLuceneVersion()));
        FullTextQuery query = Search.getFullTextEntityManager((EntityManager)this.entityManager).createFullTextQuery(parser.parse(searchQuery), new Class[]{Book.class});
        return query.getResultList();
    }
}

