/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.id;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.Search;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.id.PersonCustomDocumentId;
import org.hibernate.search.test.id.PersonPK;
import org.hibernate.search.test.util.LeakingLuceneBackend;

public class EmbeddedIdWithDocumentIdTest
extends SearchTestCase {
    public void testFieldBridge() throws Exception {
        LeakingLuceneBackend.reset();
        PersonPK johnDoePk = new PersonPK();
        johnDoePk.setFirstName("John");
        johnDoePk.setLastName("Doe");
        PersonCustomDocumentId johnDoe = new PersonCustomDocumentId();
        johnDoe.setFavoriteColor("Blue");
        johnDoe.setPersonNames(johnDoePk);
        johnDoe.setSecurityNumber("AB123");
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.save((Object)johnDoe);
        tx.commit();
        s.clear();
        List lastProcessedQueue = LeakingLuceneBackend.getLastProcessedQueue();
        EmbeddedIdWithDocumentIdTest.assertEquals((int)1, (int)lastProcessedQueue.size());
        LuceneWork luceneWork = (LuceneWork)lastProcessedQueue.get(0);
        EmbeddedIdWithDocumentIdTest.assertEquals((String)"AB123", (String)luceneWork.getIdInString());
        tx = s.beginTransaction();
        QueryBuilder queryBuilder = this.getSearchFactory().buildQueryBuilder().forEntity(PersonCustomDocumentId.class).get();
        Query query = ((TermMatchingContext)queryBuilder.keyword().onField("id").ignoreAnalyzer()).matching((Object)"AB123").createQuery();
        List results = Search.getFullTextSession((Session)s).createFullTextQuery(query, new Class[]{PersonCustomDocumentId.class}).list();
        EmbeddedIdWithDocumentIdTest.assertEquals((int)1, (int)results.size());
        johnDoe = (PersonCustomDocumentId)results.get(0);
        johnDoe.setFavoriteColor("Red");
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        results = Search.getFullTextSession((Session)s).createFullTextQuery(query, new Class[]{PersonCustomDocumentId.class}).list();
        EmbeddedIdWithDocumentIdTest.assertEquals((int)1, (int)results.size());
        johnDoe = (PersonCustomDocumentId)results.get(0);
        EmbeddedIdWithDocumentIdTest.assertEquals((String)"Red", (String)johnDoe.getFavoriteColor());
        s.delete(results.get(0));
        tx.commit();
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{PersonCustomDocumentId.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.worker.backend", LeakingLuceneBackend.class.getName());
    }
}

