/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.query.ElectricalProperties;
import org.hibernate.search.test.query.Employee;

public class TermVectorTest
extends SearchTestCase {
    public void testPositionOffsets() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.createIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        SearchFactory searchFactory = s.getSearchFactory();
        IndexReader reader = searchFactory.getIndexReaderAccessor().open(new Class[]{ElectricalProperties.class});
        int x = 0;
        TermPositionVector vector = (TermPositionVector)reader.getTermFreqVector(x, "content");
        TermVectorTest.assertNotNull((Object)vector);
        String[] terms = vector.getTerms();
        int[] freqs = vector.getTermFrequencies();
        TermVectorTest.assertEquals((String)"electrical", (String)terms[x]);
        TermVectorTest.assertEquals((int)2, (int)freqs[x]);
        TermVectorOffsetInfo[] offsets = vector.getOffsets(x);
        TermVectorTest.assertEquals((int)0, (int)offsets[x].getStartOffset());
        TermVectorTest.assertEquals((int)10, (int)offsets[x].getEndOffset());
        int[] termPositions = vector.getTermPositions(0);
        TermVectorTest.assertEquals((int)0, (int)termPositions[0]);
        TermVectorTest.assertEquals((int)3, (int)termPositions[1]);
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        searchFactory.getIndexReaderAccessor().close(reader);
        tx.commit();
        s.close();
    }

    public void testNoTermVector() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Employee e1 = new Employee(1000, "Griffin", "ITech");
        s.save((Object)e1);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        SearchFactory searchFactory = s.getSearchFactory();
        IndexReader reader = searchFactory.getIndexReaderAccessor().open(new Class[]{Employee.class});
        TermPositionVector vector = (TermPositionVector)reader.getTermFreqVector(0, "dept");
        TermVectorTest.assertNull((String)"should not find a term position vector", (Object)vector);
        for (Object element : s.createQuery("from " + ElectricalProperties.class.getName()).list()) {
            s.delete(element);
        }
        searchFactory.getIndexReaderAccessor().close(reader);
        tx.commit();
        s.close();
    }

    private void createIndex(FullTextSession s) {
        this.storeSeparately(s, new ElectricalProperties(1000, "Electrical Engineers measure Electrical Properties"));
        this.storeSeparately(s, new ElectricalProperties(1001, "Electrical Properties are interesting"));
        this.storeSeparately(s, new ElectricalProperties(1002, "Electrical Properties are measurable properties"));
    }

    private void storeSeparately(FullTextSession s, ElectricalProperties ep) {
        Transaction tx = s.beginTransaction();
        s.save((Object)ep);
        tx.commit();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{ElectricalProperties.class, Employee.class};
    }
}

