/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.concurrency;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessor;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.util.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1623")
public class ConcurrentFlushTest
extends SearchTestCase {
    private static final int STORED_ENTRIES = 150;
    private static final AtomicInteger indexedElements = new AtomicInteger();

    @Test
    public void testPropertiesIndexing() {
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 150; ++i) {
            executorService.execute(new InsertEntityJob(this.getSessionFactory(), i));
        }
        try {
            executorService.shutdown();
            executorService.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Assert.fail((String)("unexpected error " + e.getMessage()));
        }
        Assert.assertEquals((long)150L, (long)indexedElements.get());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{FlushedStuff.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.worker.backend", SlowCountingBackend.class.getName());
    }

    public static class SlowCountingBackend
    extends LuceneBackendQueueProcessor {
        public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
            indexedElements.incrementAndGet();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Indexed
    @Entity
    @Table(name="FLUSHEDSTUFF")
    public static class FlushedStuff {
        @Id
        public int id;
        public String name;
    }

    public class InsertEntityJob
    implements Runnable {
        private final SessionFactory sessionFactory;
        private final int jobNumber;

        public InsertEntityJob(SessionFactory sessionFactory, int jobNumber) {
            this.sessionFactory = sessionFactory;
            this.jobNumber = jobNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Session session = this.sessionFactory.openSession();
            try {
                FlushedStuff stuff = new FlushedStuff();
                stuff.id = this.jobNumber;
                stuff.name = "Some job code #" + this.jobNumber;
                session.save((Object)stuff);
                session.flush();
            }
            catch (HibernateException e) {
                e.printStackTrace();
            }
            finally {
                session.close();
            }
        }
    }
}

