/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.bridge.builtin.ClassBridge;
import org.hibernate.search.test.SearchTestCase;

public class TransactionSynchronizationTest
extends SearchTestCase {
    public void testProperExceptionPropagation() throws Exception {
        FullTextSession fts = Search.getFullTextSession((Session)this.openSession());
        boolean raised = false;
        Transaction transaction = fts.beginTransaction();
        try {
            Test test = new Test();
            test.setIncorrectType("not a class");
            fts.persist((Object)test);
            transaction.commit();
            TransactionSynchronizationTest.fail((String)"An exception should have been raised");
        }
        catch (Exception e) {
            raised = true;
            transaction.rollback();
        }
        TransactionSynchronizationTest.assertTrue((String)"An exception should have been raised", (boolean)raised);
        fts.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Test.class};
    }

    @Entity
    @Indexed
    @Table(name="Test007")
    public static class Test {
        private Integer id;
        private String incorrectType;

        @Id
        @GeneratedValue
        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        @Field(bridge=@FieldBridge(impl=ClassBridge.class))
        public String getIncorrectType() {
            return this.incorrectType;
        }

        public void setIncorrectType(String incorrectType) {
            this.incorrectType = incorrectType;
        }
    }
}

