/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.id;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.test.id.PersonPK;

public class PersonPKBridge
implements TwoWayFieldBridge {
    public Object get(String name, Document document) {
        PersonPK id = new PersonPK();
        Fieldable field = document.getFieldable(name + ".firstName");
        id.setFirstName(field.stringValue());
        field = document.getFieldable(name + ".lastName");
        id.setLastName(field.stringValue());
        return id;
    }

    public String objectToString(Object object) {
        PersonPK id = (PersonPK)object;
        StringBuilder sb = new StringBuilder();
        sb.append(id.getFirstName()).append(" ").append(id.getLastName());
        return sb.toString();
    }

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        PersonPK id = (PersonPK)value;
        luceneOptions.addFieldToDocument(name + ".firstName", id.getFirstName(), document);
        luceneOptions.addFieldToDocument(name + ".lastName", id.getLastName(), document);
        luceneOptions.addFieldToDocument(name, this.objectToString(id), document);
    }
}

