/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jpa;

import javax.persistence.EntityManager;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.jpa.Bretzel;
import org.hibernate.search.test.jpa.JPATestCase;
import org.junit.Assert;
import org.junit.Test;

public class EntityManagerTest
extends JPATestCase {
    @Test
    public void testMassIndexer() throws Exception {
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        em.getTransaction().begin();
        Bretzel bretzel = new Bretzel(23.0f, 34.0f);
        em.persist((Object)bretzel);
        em.getTransaction().commit();
        em.clear();
        Assert.assertEquals((long)1L, (long)this.countBretzelsViaIndex(em));
        em.purgeAll(Bretzel.class);
        em.flushToIndexes();
        Assert.assertEquals((long)0L, (long)this.countBretzelsViaIndex(em));
        em.createIndexer(new Class[]{Bretzel.class}).startAndWait();
        Assert.assertEquals((long)1L, (long)this.countBretzelsViaIndex(em));
    }

    private int countBretzelsViaIndex(FullTextEntityManager em) {
        QueryBuilder queryBuilder = em.getSearchFactory().buildQueryBuilder().forEntity(Bretzel.class).get();
        Query allQuery = queryBuilder.all().createQuery();
        FullTextQuery fullTextQuery = em.createFullTextQuery(allQuery, new Class[]{Bretzel.class});
        return fullTextQuery.getResultSize();
    }

    @Test
    public void testQuery() throws Exception {
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        em.getTransaction().begin();
        Bretzel bretzel = new Bretzel(23.0f, 34.0f);
        em.persist((Object)bretzel);
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        QueryParser parser = new QueryParser(EntityManagerTest.getTargetLuceneVersion(), "title", TestConstants.stopAnalyzer);
        Query query = parser.parse("saltQty:noword");
        Assert.assertEquals((long)0L, (long)em.createFullTextQuery(query, new Class[0]).getResultList().size());
        query = new TermQuery(new Term("saltQty", "23.0"));
        Assert.assertEquals((String)"getResultList", (long)1L, (long)em.createFullTextQuery(query, new Class[0]).getResultList().size());
        Assert.assertEquals((String)"getSingleResult and object retrieval", (double)23.0, (double)((Bretzel)em.createFullTextQuery(query, new Class[0]).getSingleResult()).getSaltQty(), (double)0.0);
        Assert.assertEquals((long)1L, (long)em.createFullTextQuery(query, new Class[0]).getResultSize());
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        em.remove(em.find(Bretzel.class, (Object)bretzel.getId()));
        em.getTransaction().commit();
        em.close();
    }

    @Test
    public void testIndex() {
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        em.getTransaction().begin();
        Bretzel bretzel = new Bretzel(23.0f, 34.0f);
        em.persist((Object)bretzel);
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        em.index(em.find(Bretzel.class, (Object)bretzel.getId()));
        em.getTransaction().commit();
        em.getTransaction().begin();
        em.remove(em.find(Bretzel.class, (Object)bretzel.getId()));
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public Class[] getAnnotatedClasses() {
        return new Class[]{Bretzel.class};
    }
}

