/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.query.Person;

public class QueryUnindexedEntityTest
extends SearchTestCase {
    public void testQueryOnAllEntities() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Person person = new Person();
        person.setName("Jon Doe");
        s.save((Object)person);
        tx.commit();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "name", TestConstants.standardAnalyzer);
        Query query = parser.parse("name:foo");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[0]);
        try {
            hibQuery.list();
            QueryUnindexedEntityTest.fail();
        }
        catch (SearchException e) {
            QueryUnindexedEntityTest.assertTrue((String)"Wrong message", (boolean)e.getMessage().startsWith("There are no mapped entities"));
        }
        tx.rollback();
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Person.class};
    }
}

