/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend;

import org.hibernate.cfg.Configuration;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessor;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.impl.MutableSearchFactory;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.SearchTestCaseJUnit4;
import org.hibernate.search.test.backend.Clock;
import org.junit.Assert;
import org.junit.Test;

public class WorkQueueLengthConfiguredTest
extends SearchTestCaseJUnit4 {
    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Clock.class};
    }

    @Test
    public void testNothingTest() {
        MutableSearchFactory searchFactory = (MutableSearchFactory)this.getSearchFactory();
        EntityIndexBinding indexBindingForEntity = searchFactory.getIndexBinding(Clock.class);
        IndexManager[] indexManagers = indexBindingForEntity.getIndexManagers();
        Assert.assertEquals((long)1L, (long)indexManagers.length);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexManagers[0];
        LuceneBackendQueueProcessor backend = (LuceneBackendQueueProcessor)indexManager.getBackendQueueProcessor();
        Assert.assertEquals((long)5L, (long)backend.getIndexResources().getMaxQueueLength());
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.max_queue_length", "5");
    }
}

