/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.indexingStrategy;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.test.SearchTestCaseJUnit4;
import org.junit.Assert;
import org.junit.Test;

public class ManualIndexingStrategyTest
extends SearchTestCaseJUnit4 {
    @Test
    public void testMultipleEntitiesPerIndex() throws Exception {
        this.indexTestEntity();
        Assert.assertEquals((String)"Due to manual indexing being enabled no automatic indexing should have occurred", (long)0L, (long)this.getDocumentNbr());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{TestEntity.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.indexing_strategy", "manual");
    }

    private void indexTestEntity() {
        Session session = this.getSessionFactory().openSession();
        session.getTransaction().begin();
        session.persist((Object)new TestEntity());
        session.getTransaction().commit();
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDocumentNbr() throws Exception {
        IndexReader reader = IndexReader.open((Directory)this.getDirectory(TestEntity.class));
        try {
            int n = reader.numDocs();
            return n;
        }
        finally {
            reader.close();
        }
    }

    @Indexed
    @Entity
    @Table(name="TestEntity")
    public static class TestEntity {
        @Id
        @GeneratedValue
        private int id;
    }
}

