/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test;

import java.io.File;
import org.apache.lucene.store.Directory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.test.DefaultTestResourceManager;
import org.hibernate.search.test.TestResourceManager;
import org.junit.After;
import org.junit.Before;

public abstract class SearchTestCaseJUnit4
implements TestResourceManager {
    private DefaultTestResourceManager testResourceManager;

    @Before
    public void setUp() throws Exception {
        DefaultTestResourceManager testResourceManager = this.getTestResourceManager();
        if (testResourceManager.needsConfigurationRebuild()) {
            this.configure(testResourceManager.getCfg());
            testResourceManager.buildConfiguration();
        }
        testResourceManager.openSessionFactory();
    }

    @After
    public void tearDown() throws Exception {
        this.getTestResourceManager().defaultTearDown();
    }

    @Override
    public final Configuration getCfg() {
        return this.getTestResourceManager().getCfg();
    }

    @Override
    public final void openSessionFactory() {
        this.getTestResourceManager().openSessionFactory();
    }

    @Override
    public final void closeSessionFactory() {
        this.getTestResourceManager().closeSessionFactory();
    }

    @Override
    public final SessionFactory getSessionFactory() {
        return this.getTestResourceManager().getSessionFactory();
    }

    @Override
    public final SearchFactory getSearchFactory() {
        return this.getTestResourceManager().getSearchFactory();
    }

    @Override
    public SearchFactoryImplementor getSearchFactoryImpl() {
        return this.getTestResourceManager().getSearchFactoryImpl();
    }

    @Override
    public final Session openSession() {
        return this.getTestResourceManager().openSession();
    }

    @Override
    public final Session getSession() {
        return this.getTestResourceManager().getSession();
    }

    @Override
    public void ensureIndexesAreEmpty() {
        this.getTestResourceManager().ensureIndexesAreEmpty();
    }

    @Override
    public File getBaseIndexDir() {
        return this.getTestResourceManager().getBaseIndexDir();
    }

    @Override
    public Directory getDirectory(Class<?> clazz) {
        return this.getTestResourceManager().getDirectory(clazz);
    }

    @Override
    public void forceConfigurationRebuild() {
        this.getTestResourceManager().forceConfigurationRebuild();
    }

    @Override
    public boolean needsConfigurationRebuild() {
        return this.getTestResourceManager().needsConfigurationRebuild();
    }

    protected abstract Class<?>[] getAnnotatedClasses();

    protected void configure(Configuration cfg) {
        this.getTestResourceManager().applyDefaultConfiguration(cfg);
    }

    private synchronized DefaultTestResourceManager getTestResourceManager() {
        if (this.testResourceManager == null) {
            this.testResourceManager = new DefaultTestResourceManager(this.getAnnotatedClasses());
        }
        return this.testResourceManager;
    }
}

