/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.optimizations;

import java.util.List;
import junit.framework.Assert;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.hibernate.search.test.util.LeakingLuceneBackend;
import org.hibernate.search.test.util.LeakingOptimizer;
import org.junit.Test;

public class UpdateOperationsTest {
    @Test
    public void testBackendOperationsCount() {
        this.invokeTest(true, 2);
    }

    @Test
    public void testDisablingOptimization() {
        this.invokeTest(false, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeTest(boolean indexMetadataIsComplete, int expectedBackendOperations) {
        FullTextSessionBuilder fullTextSessionBuilder = UpdateOperationsTest.createSearchFactory(indexMetadataIsComplete);
        try {
            LeakingOptimizer.reset();
            LeakingLuceneBackend.reset();
            FullTextSession session = fullTextSessionBuilder.openFullTextSession();
            Assert.assertEquals((long)0L, (long)LeakingOptimizer.getTotalOperations());
            Transaction tx = session.beginTransaction();
            session.persist((Object)new Document("The Book", "many paper pages assembled together at one side", "[old language you don't understand]"));
            tx.commit();
            Assert.assertEquals((long)1L, (long)LeakingOptimizer.getTotalOperations());
            Assert.assertEquals((int)1, (int)LeakingLuceneBackend.getLastProcessedQueue().size());
            tx = session.beginTransaction();
            List list = session.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]).list();
            Document doc = (Document)list.get(0);
            doc.setSummary("Example of what was used in ancient times to read");
            tx.commit();
            Assert.assertEquals((int)1, (int)LeakingLuceneBackend.getLastProcessedQueue().size());
            Assert.assertEquals((long)expectedBackendOperations, (long)LeakingOptimizer.getTotalOperations());
        }
        finally {
            fullTextSessionBuilder.close();
        }
    }

    private static FullTextSessionBuilder createSearchFactory(boolean indexMetadataIsComplete) {
        FullTextSessionBuilder builder = new FullTextSessionBuilder().setProperty("hibernate.search.default.worker.backend", LeakingLuceneBackend.class.getName()).setProperty("hibernate.search.default.optimizer.implementation", LeakingOptimizer.class.getCanonicalName()).addAnnotatedClass(Document.class);
        if (!indexMetadataIsComplete) {
            builder.setProperty("hibernate.search.default.index_metadata_complete", "false");
        }
        return builder.build();
    }
}

